/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.listener.gui;

import com.github.johrstrom.collector.gui.AbstractCollectorTable;
import com.github.johrstrom.collector.gui.Flatten;
import com.github.johrstrom.config.gui.ConfigCollectorTable;
import com.github.johrstrom.listener.ListenerCollectorConfig;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableColumn;
import org.apache.jorphan.reflect.Functor;

public class ListenerCollectorTable
extends AbstractCollectorTable<ListenerCollectorConfig>
implements Flatten {
    private static final long serialVersionUID = 4429063284832140575L;
    public static JComboBox<String> listenToComboBox;
    public static JComboBox<String> measuringComboBox;
    private static ConfigCollectorTable stealFrom;
    public static int LISTEN_TO_INDEX;
    public static int MEARSURING_INDEX;

    public ListenerCollectorTable() {
        super(ListenerCollectorConfig.class);
    }

    @Override
    public Flatten getGuiHelper() {
        return this;
    }

    @Override
    public void modifyColumns() {
        TableColumn column = this.table.getColumnModel().getColumn(ConfigCollectorTable.TYPE_INDEX);
        column.setCellEditor(new DefaultCellEditor(ConfigCollectorTable.typeComboBox));
        column = this.table.getColumnModel().getColumn(LISTEN_TO_INDEX);
        column.setCellEditor(new DefaultCellEditor(listenToComboBox));
        column = this.table.getColumnModel().getColumn(MEARSURING_INDEX);
        column.setCellEditor(new DefaultCellEditor(measuringComboBox));
    }

    @Override
    public Functor[] getReadFunctors() {
        ArrayList<Functor> functors = new ArrayList<Functor>(Arrays.asList(stealFrom.getReadFunctors()));
        functors.add(new Functor("getListenTo"));
        functors.add(new Functor("getMeasuring"));
        return functors.toArray(new Functor[functors.size()]);
    }

    @Override
    public Functor[] getWriteFunctors() {
        ArrayList<Functor> functors = new ArrayList<Functor>(Arrays.asList(stealFrom.getWriteFunctors()));
        functors.add(new Functor("setListenTo"));
        functors.add(new Functor("setMeasuring"));
        return functors.toArray(new Functor[functors.size()]);
    }

    @Override
    public String[] getHeaders() {
        ArrayList<String> headers = new ArrayList<String>(Arrays.asList(stealFrom.getHeaders()));
        headers.add("Listen to");
        headers.add("Measuring");
        return headers.toArray(new String[headers.size()]);
    }

    @Override
    public Class<?>[] getEditorClasses() {
        ArrayList editors = new ArrayList(Arrays.asList(stealFrom.getEditorClasses()));
        editors.add(ComboBoxEditor.class);
        editors.add(ComboBoxEditor.class);
        return editors.toArray(new Class[editors.size()]);
    }

    public static JComboBox<String> measuringBox() {
        JComboBox<String> box = new JComboBox<String>();
        for (ListenerCollectorConfig.Measurable value : ListenerCollectorConfig.Measurable.values()) {
            box.addItem(value.toString());
        }
        return box;
    }

    static {
        stealFrom = new ConfigCollectorTable();
        LISTEN_TO_INDEX = ConfigCollectorTable.BASE_COLUMN_SIZE;
        MEARSURING_INDEX = LISTEN_TO_INDEX + 1;
        listenToComboBox = new JComboBox();
        listenToComboBox.addItem("samples");
        listenToComboBox.addItem("assertions");
        measuringComboBox = ListenerCollectorTable.measuringBox();
    }
}

