/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.listener.gui;

import com.github.johrstrom.collector.CollectorElement;
import com.github.johrstrom.listener.PrometheusListener;
import com.github.johrstrom.listener.gui.ListenerCollectorTable;
import java.awt.BorderLayout;
import java.util.List;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusListenerGui
extends AbstractListenerGui {
    private static final long serialVersionUID = 4984653136457108054L;
    private ListenerCollectorTable table = new ListenerCollectorTable();
    private Logger log = LoggerFactory.getLogger(PrometheusListenerGui.class);

    public PrometheusListenerGui() {
        this.log.debug("making a new listener gui: {}", (Object)this.toString());
        this.init();
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    protected PrometheusListenerGui clone() throws CloneNotSupportedException {
        return new PrometheusListenerGui();
    }

    public String getStaticLabel() {
        return "Prometheus Listener";
    }

    public String getName() {
        return super.getName() == null ? this.getStaticLabel() : super.getName();
    }

    public void configure(TestElement ele) {
        super.configure(ele);
        if (ele instanceof CollectorElement) {
            try {
                this.table.populateTable((CollectorElement)ele);
            }
            catch (Exception e) {
                this.log.error("didn't modify test element because {}. {}", e.getClass(), (Object)e.getMessage());
            }
        }
        this.setName(ele.getName() == null ? this.getStaticLabel() : ele.getName());
        this.setComment(ele.getComment() == null ? "" : ele.getComment());
    }

    public TestElement createTestElement() {
        PrometheusListener listener = new PrometheusListener();
        listener.setProperty("TestElement.gui_class", PrometheusListenerGui.class.getName());
        listener.setProperty("TestElement.test_class", PrometheusListener.class.getName());
        this.modifyTestElement((TestElement)listener);
        return listener;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.add(this.makeTitlePanel(), "North");
        this.add(this.table, "Center");
    }

    public void modifyTestElement(TestElement ele) {
        if (!(ele instanceof CollectorElement)) {
            return;
        }
        CollectorElement config = (CollectorElement)ele;
        List collectors = this.table.getRowsAsCollectors();
        config.setCollectorConfigs(collectors);
        config.setName(this.getName());
        config.setComment(this.getComment());
    }

    public void clearGui() {
        super.clearGui();
        this.table.clearModelData();
    }
}

