/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.listener.updater;

import com.github.johrstrom.collector.JMeterCollectorRegistry;
import com.github.johrstrom.listener.ListenerCollectorConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;

public abstract class AbstractUpdater {
    public static String NULL = "null";
    protected ListenerCollectorConfig config;
    protected static final JMeterCollectorRegistry registry = JMeterCollectorRegistry.getInstance();
    private Map<String, Integer> varIndexLookup;

    public AbstractUpdater(ListenerCollectorConfig cfg) {
        this.config = cfg;
        this.buildVarLookup();
    }

    public abstract void update(SampleEvent var1);

    protected String[] labelValues(SampleEvent event) {
        String[] labels = this.config.getLabels();
        String[] values = new String[labels.length];
        JMeterVariables vars = JMeterContextService.getContext().getVariables();
        for (int i = 0; i < labels.length; ++i) {
            String name = labels[i];
            String value = null;
            if (name.equalsIgnoreCase("label")) {
                value = event.getResult().getSampleLabel();
            } else if (name.equalsIgnoreCase("code")) {
                value = event.getResult().getResponseCode();
            } else if (this.varIndexLookup.get(name) != null) {
                int idx = this.varIndexLookup.get(name);
                value = event.getVarValue(idx);
            } else if (vars != null) {
                value = vars.get(name);
            }
            values[i] = value == null || value.isEmpty() ? NULL : value;
        }
        return values;
    }

    protected String[] labelValues(AssertionContext ctx) {
        String[] labels = this.config.getLabels();
        String[] values = new String[labels.length];
        JMeterVariables vars = JMeterContextService.getContext().getVariables();
        for (int i = 0; i < labels.length; ++i) {
            String name = labels[i];
            String value = null;
            if (name.equalsIgnoreCase("label")) {
                value = ctx.assertion.getName();
            } else if (this.varIndexLookup.get(name) != null) {
                int idx = this.varIndexLookup.get(name);
                value = ctx.event.getVarValue(idx);
            } else if (vars != null) {
                value = vars.get(name);
            }
            values[i] = value == null || value.isEmpty() ? NULL : value;
        }
        return values;
    }

    private void buildVarLookup() {
        this.varIndexLookup = new HashMap<String, Integer>();
        for (int i = 0; i < SampleEvent.getVarCount(); ++i) {
            String name = SampleEvent.getVarName((int)i);
            if (!this.inLabels(name)) continue;
            this.varIndexLookup.put(name, i);
        }
    }

    private boolean inLabels(String searchFor) {
        String[] labels = this.config.getLabels();
        for (int i = 0; i < labels.length; ++i) {
            if (!labels[i].equalsIgnoreCase(searchFor)) continue;
            return true;
        }
        return false;
    }

    public static class AssertionContext {
        public AssertionResult assertion;
        public SampleEvent event;

        public AssertionContext(AssertionResult a, SampleEvent e) {
            this.assertion = a;
            this.event = e;
        }
    }
}

