/*
 * Decompiled with CFR 0.152.
 */
package com.github.johrstrom.listener.updater;

import com.github.johrstrom.collector.SuccessRatioCollector;
import com.github.johrstrom.listener.ListenerCollectorConfig;
import com.github.johrstrom.listener.updater.AbstractUpdater;
import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountTypeUpdater
extends AbstractUpdater {
    private static final Logger log = LoggerFactory.getLogger(CountTypeUpdater.class);

    public CountTypeUpdater(ListenerCollectorConfig cfg) {
        super(cfg);
    }

    @Override
    public void update(SampleEvent event) {
        if (this.config.listenToSamples()) {
            boolean successful = event.getResult().isSuccessful();
            this.inc(this.labelValues(event), successful);
        } else if (this.config.listenToAssertions()) {
            for (AssertionResult assertion : event.getResult().getAssertionResults()) {
                this.updateAssertions(new AbstractUpdater.AssertionContext(assertion, event));
            }
        }
    }

    protected void inc(String[] labels, boolean successful) {
        try {
            Collector collector = registry.getOrCreateAndRegister(this.config);
            if (collector instanceof Counter) {
                Counter c = (Counter)collector;
                switch (this.config.getMeasuringAsEnum()) {
                    case CountTotal: {
                        ((Counter.Child)c.labels(labels)).inc();
                        break;
                    }
                    case FailureTotal: {
                        if (successful) break;
                        ((Counter.Child)c.labels(labels)).inc();
                        break;
                    }
                    case SuccessTotal: {
                        if (!successful) break;
                        ((Counter.Child)c.labels(labels)).inc();
                        break;
                    }
                }
            } else if (collector instanceof SuccessRatioCollector) {
                SuccessRatioCollector c = (SuccessRatioCollector)collector;
                if (successful) {
                    c.incrementSuccess(labels);
                } else {
                    c.incrementFailure(labels);
                }
            }
        }
        catch (Exception e) {
            log.error("Did not update {} because of error: {}", (Object)this.config.getMetricName(), (Object)e.getMessage());
            log.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected void updateAssertions(AbstractUpdater.AssertionContext ctx) {
        String[] labels = this.labelValues(ctx);
        boolean successful = !ctx.assertion.isFailure();
        this.inc(labels, successful);
    }
}

