/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino;

import com.github.jonatino.netvars.NetVars;
import com.github.jonatino.offsets.Offsets;
import com.github.jonatino.process.Module;
import com.github.jonatino.process.Process;
import com.github.jonatino.process.Processes;
import com.sun.jna.Platform;

public final class OffsetManager {
    private static Process process;
    private static Module clientModule;
    private static Module engineModule;

    public static void initAll() {
        OffsetManager.loadNetVars();
        OffsetManager.loadOffsets();
    }

    public static void loadNetVars() {
        NetVars.load();
    }

    public static void loadOffsets() {
        Offsets.load();
    }

    public static Process process() {
        return process;
    }

    public static Module clientModule() {
        return clientModule;
    }

    public static Module engineModule() {
        return engineModule;
    }

    private static void waitUntilFound(String message, Clause clause) {
        System.out.print("Looking for " + message + ". Please wait.");
        while (!clause.get()) {
            try {
                Thread.sleep(3000L);
                System.out.print(".");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("\nFound " + message + "!");
    }

    static {
        StringBuilder procBaseName = new StringBuilder("csgo");
        StringBuilder clientBaseName = new StringBuilder("client");
        StringBuilder engineBaseName = new StringBuilder("engine");
        if (Platform.isWindows()) {
            procBaseName.append(".exe");
            clientBaseName.append(".dll");
            engineBaseName.append(".dll");
        } else if (Platform.isLinux()) {
            procBaseName.append("_linux");
            clientBaseName.append("_client.so");
            engineBaseName.append("_client.so");
        } else if (Platform.isMac()) {
            procBaseName.append("_osx");
            clientBaseName.append(".dylib");
            engineBaseName.append(".dylib");
        } else {
            throw new RuntimeException("Unsupported operating system type!");
        }
        String processName = procBaseName.toString();
        String clientName = clientBaseName.toString();
        String engineName = engineBaseName.toString();
        OffsetManager.waitUntilFound("process", () -> {
            process = Processes.byName((String)processName);
            return process != null;
        });
        OffsetManager.waitUntilFound("client module", () -> {
            clientModule = process.findModule(clientName);
            return clientModule != null;
        });
        OffsetManager.waitUntilFound("engine module", () -> {
            engineModule = process.findModule(engineName);
            return engineModule != null;
        });
    }

    @FunctionalInterface
    private static interface Clause {
        public boolean get();
    }
}

