/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.misc;

import com.github.jonatino.misc.Cacheable;
import com.github.jonatino.process.Module;
import java.util.Arrays;

public final class PatternScanner {
    public static final int READ = 1;
    public static final int SUBTRACT = 2;

    public static int getAddressForPattern(Module module, int pattern_offset, int address_offset, int flags, String className) {
        return PatternScanner.getAddressForPattern(module, pattern_offset, address_offset, flags, className.getBytes());
    }

    public static int getAddressForPattern(Module module, int pattern_offset, int address_offset, int flags, int value) {
        return PatternScanner.getAddressForPattern(module, pattern_offset, address_offset, flags, PatternScanner.toByteArray(value));
    }

    public static int getAddressForPattern(Module module, int pattern_offset, int address_offset, int flags, int ... values) {
        return PatternScanner.getAddressForPattern(module, pattern_offset, address_offset, flags, PatternScanner.toByteArray(values));
    }

    public static int getAddressForPattern(Module module, int pattern_offset, int address_offset, int flags, byte ... values) {
        long off = module.size() - values.length;
        int i = 0;
        while ((long)i < off) {
            if (PatternScanner.checkMask(module, i, values)) {
                i = (int)((long)i + (module.address() + (long)pattern_offset));
                if ((flags & 1) == 1) {
                    i = module.process().readInt((long)i);
                }
                if ((flags & 2) == 2) {
                    i = (int)((long)i - module.address());
                }
                return i + address_offset;
            }
            ++i;
        }
        throw new IllegalStateException("Can not find offset inside of " + module.name() + " with pattern " + Arrays.toString(values));
    }

    private static boolean checkMask(Module module, int offset, byte[] pMask) {
        for (int i = 0; i < pMask.length; ++i) {
            if (pMask[i] == 0 || pMask[i] == module.data().getByte((long)(offset + i))) continue;
            return false;
        }
        return true;
    }

    private static byte[] toByteArray(int value) {
        return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
    }

    private static byte[] toByteArray(int ... value) {
        byte[] byteVals = Cacheable.array((int)value.length);
        for (int i = 0; i < value.length; ++i) {
            byteVals[i] = (byte)value[i];
        }
        return byteVals;
    }
}

