/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.netvars;

import com.github.jonatino.OffsetManager;
import com.github.jonatino.misc.PatternScanner;
import com.github.jonatino.misc.Strings;
import com.github.jonatino.netvars.impl.ClientClass;
import com.github.jonatino.netvars.impl.RecvProp;
import com.github.jonatino.netvars.impl.RecvTable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;

public final class NetVars {
    private static final ArrayDeque<NetVar> netVars = new ArrayDeque(16500);
    private static final ClientClass clientClass = new ClientClass();
    private static final RecvTable table = new RecvTable();
    private static final RecvProp prop = new RecvProp();

    public static void load() {
        int firstclass = PatternScanner.getAddressForPattern(OffsetManager.clientModule(), 0, 0, 0, "DT_TEWorldDecal");
        firstclass = PatternScanner.getAddressForPattern(OffsetManager.clientModule(), 43, 0, 1, firstclass);
        clientClass.setBase(firstclass);
        while (clientClass.readable()) {
            table.setBase(clientClass.table());
            String tableName = table.tableName();
            if (tableName.length() > 0 && table.propCount() > 0) {
                NetVars.scanTable(table, 0, tableName);
            }
            clientClass.setBase(clientClass.next());
        }
    }

    public static void dump() {
        ArrayList text = new ArrayList();
        netVars.forEach(n -> text.add(n.toString()));
        try {
            Files.write(Paths.get("NetVars.txt", new String[0]), text, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void scanTable(RecvTable table, int offset, String className) {
        for (int i = 0; i < table.propCount(); ++i) {
            int child;
            prop.setBase(table.propForId(i));
            prop.setOffset(offset);
            String propName = prop.name();
            int propOffset = prop.offset();
            if (Character.isDigit(propName.charAt(0))) continue;
            if (propOffset != 0) {
                netVars.add(new NetVar(className, propName, propOffset));
            }
            if ((child = prop.table()) == 0) continue;
            NetVars.scanTable(new RecvTable().setBase(child), propOffset, className);
        }
    }

    public static int byName(String className, String varname) {
        for (NetVar var : netVars) {
            if (!var.className.equals(className) || !var.varName.equals(varname)) continue;
            return var.offset;
        }
        throw new RuntimeException("NetVar [" + className + ", " + varname + "] not found!");
    }

    private static class NetVar {
        private final String className;
        private final String varName;
        private final int offset;

        private NetVar(String className, String varName, int offset) {
            this.className = className;
            this.varName = varName;
            this.offset = offset;
        }

        public String toString() {
            return this.className + " " + this.varName + " = " + Strings.hex((int)this.offset);
        }
    }
}

