/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.tools;

import com.github.jonatino.OffsetManager;
import com.github.jonatino.misc.PatternScanner;
import com.github.jonatino.netvars.impl.ClientClass;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;

public final class ClassIdDumper {
    public static void main(String[] args) {
        int firstclass = PatternScanner.getAddressForPattern(OffsetManager.clientModule(), 0, 0, 0, "DT_TEWorldDecal");
        firstclass = PatternScanner.getAddressForPattern(OffsetManager.clientModule(), 43, 0, 1, firstclass);
        ArrayList<ClientClassInfo> text = new ArrayList<ClientClassInfo>();
        ClientClass clientClass = new ClientClass();
        clientClass.setBase(firstclass);
        while (clientClass.readable()) {
            text.add(new ClientClassInfo(clientClass.className(), clientClass.classId()));
            clientClass.setBase(clientClass.next());
        }
        text.sort(new Comparator<ClientClassInfo>(){

            @Override
            public int compare(ClientClassInfo o1, ClientClassInfo o2) {
                return Integer.compare(o1.id, o2.id);
            }
        });
        ArrayList lines = new ArrayList();
        text.forEach(k -> lines.add(k.toString()));
        try {
            Files.write(Paths.get("ClassIds.txt", new String[0]), lines, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ClientClassInfo {
        private String name;
        private int id;

        public ClientClassInfo(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.name).append("(").append(this.id);
            if (this.name.startsWith("CWeapon") && !this.name.equals("CWeaponCubemap") && !this.name.equals("CWeaponBaseItem") || this.name.startsWith("CKnife") || this.name.equals("CAK47") || this.name.equals("CDEagle") || this.name.equals("CSCAR17")) {
                b.append(", weapon = true");
            } else if (this.name.startsWith("CBaseCSGrenade") || this.name.startsWith("CBaseGrenade") || this.name.startsWith("CDecoy") || this.name.startsWith("CMolotov") || this.name.startsWith("CSmokeGrenade") || this.name.equals("ParticleSmokeGrenade") || this.name.equals("CFlashbang") || this.name.equals("CHEGrenade") || this.name.equals("CIncendiaryGrenade") || this.name.equals("CInferno")) {
                b.append(", grenade = true");
            }
            b.append("),");
            return b.toString();
        }
    }
}

