/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpeterson.jackson.module.versioning;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.github.jonpeterson.jackson.module.versioning.JsonVersionedModel;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class VersionedModelSerializer<T>
extends StdSerializer<T>
implements ResolvableSerializer {
    private final StdSerializer<T> delegate;
    private final JsonVersionedModel jsonVersionedModel;
    private final VersionedModelConverter converter;
    private final BeanPropertyDefinition serializeToVersionProperty;

    public VersionedModelSerializer(StdSerializer<T> delegate, JsonVersionedModel jsonVersionedModel, BeanPropertyDefinition serializeToVersionProperty) {
        super(delegate.handledType());
        this.delegate = delegate;
        this.jsonVersionedModel = jsonVersionedModel;
        this.serializeToVersionProperty = serializeToVersionProperty;
        Class<? extends VersionedModelConverter> converterClass = jsonVersionedModel.toPastConverterClass();
        if (converterClass != VersionedModelConverter.class) {
            try {
                this.converter = converterClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("unable to create instance of converter '" + converterClass.getName() + "'", e);
            }
        } else {
            this.converter = null;
        }
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this.delegate instanceof ResolvableSerializer) {
            ((ResolvableSerializer)this.delegate).resolve(provider);
        }
    }

    public void serialize(T value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        this.doSerialize(value, generator, provider, null);
    }

    public void serializeWithType(T value, JsonGenerator generator, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
        this.doSerialize(value, generator, provider, typeSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSerialize(T value, JsonGenerator generator, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
        JsonFactory factory = generator.getCodec().getFactory();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
        JsonGenerator bufferGenerator = factory.createGenerator((OutputStream)buffer);
        try {
            if (typeSerializer != null) {
                this.delegate.serializeWithType(value, bufferGenerator, provider, typeSerializer);
            } else {
                this.delegate.serialize(value, bufferGenerator, provider);
            }
        }
        finally {
            bufferGenerator.close();
        }
        ObjectNode modelData = (ObjectNode)factory.createParser(buffer.toByteArray()).readValueAsTree();
        String targetVersion = null;
        if (this.serializeToVersionProperty != null) {
            targetVersion = (String)this.serializeToVersionProperty.getAccessor().getValue(value);
            modelData.remove(this.serializeToVersionProperty.getName());
        }
        if (targetVersion == null) {
            targetVersion = this.jsonVersionedModel.defaultSerializeToVersion();
        }
        if (targetVersion.isEmpty()) {
            targetVersion = this.jsonVersionedModel.currentVersion();
        }
        if (this.converter != null && (this.jsonVersionedModel.alwaysConvert() || !targetVersion.equals(this.jsonVersionedModel.currentVersion()))) {
            modelData = this.converter.convert(modelData, this.jsonVersionedModel.currentVersion(), targetVersion, JsonNodeFactory.instance);
        }
        if (!targetVersion.equals(this.jsonVersionedModel.versionToSuppressPropertySerialization())) {
            modelData.put(this.jsonVersionedModel.propertyName(), targetVersion);
        }
        generator.writeTree((TreeNode)modelData);
    }
}

