/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonpeterson.jackson.module.versioning;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.github.jonpeterson.jackson.module.versioning.JsonVersionedModel;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelSerializer;
import com.github.jonpeterson.jackson.module.versioning.VersionedModelUtils;

class VersioningBeanSerializationModifier
extends BeanSerializerModifier {
    VersioningBeanSerializationModifier() {
    }

    private static <T> VersionedModelSerializer<T> createVersioningSerializer(StdSerializer<T> serializer, JsonVersionedModel jsonVersionedModel, BeanPropertyDefinition serializeToVersionProperty) {
        return new VersionedModelSerializer<T>(serializer, jsonVersionedModel, serializeToVersionProperty);
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDescription, JsonSerializer<?> serializer) {
        JsonVersionedModel jsonVersionedModel;
        if (serializer instanceof StdSerializer && (jsonVersionedModel = (JsonVersionedModel)beanDescription.getClassAnnotations().get(JsonVersionedModel.class)) != null) {
            return VersioningBeanSerializationModifier.createVersioningSerializer((StdSerializer)serializer, jsonVersionedModel, VersionedModelUtils.getSerializeToVersionProperty(beanDescription));
        }
        return serializer;
    }
}

