/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor;

import com.queryflow.accessor.AccessorFactory;
import com.queryflow.accessor.AccessorManager;
import com.queryflow.annotation.Mapper;
import com.queryflow.common.QueryFlowException;
import com.queryflow.config.DatabaseConfig;
import com.queryflow.config.parser.ConfigFileFactory;
import com.queryflow.mapper.MapperManager;
import com.queryflow.utils.Assert;
import com.queryflow.utils.ClassScanner;
import com.queryflow.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class AccessorFactoryBuilder {
    private List<DatabaseConfig> databaseConfigs = new ArrayList<DatabaseConfig>(2);
    private Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private List<String> scanPackageNames = new ArrayList<String>(2);

    public AccessorFactoryBuilder fromFile() {
        this.fromFile(null);
        return this;
    }

    public AccessorFactoryBuilder fromFile(String path) {
        List<DatabaseConfig> dbConfigs = ConfigFileFactory.parseConfigFile(path);
        for (DatabaseConfig databaseConfig : dbConfigs) {
            this.addDatabase(databaseConfig);
        }
        return this;
    }

    public AccessorFactoryBuilder addDatabase(DataSource dataSource) {
        Assert.notNull(dataSource);
        this.dataSources.put("queryflow", dataSource);
        return this;
    }

    public AccessorFactoryBuilder addDatabase(String tag, DataSource dataSource) {
        Assert.hasText(tag);
        Assert.notNull(dataSource);
        this.dataSources.put(tag, dataSource);
        return this;
    }

    public AccessorFactoryBuilder addDatabase(DatabaseConfig config) {
        Assert.notNull(config);
        this.databaseConfigs.add(config);
        return this;
    }

    public AccessorFactoryBuilder addDatabase(String url, String username, String password) {
        return this.addDatabse("queryflow", url, username, password);
    }

    public AccessorFactoryBuilder addDatabse(String tag, String url, String username, String password) {
        Assert.hasText(url);
        Assert.hasText(username);
        Assert.hasText(password);
        this.databaseConfigs.add(new DatabaseConfig(url, username, password).setTag(tag));
        return this;
    }

    public AccessorFactoryBuilder scanPackage(String ... packageNames) {
        if (packageNames != null && packageNames.length > 0) {
            for (String packageName : packageNames) {
                if (Utils.isBlank(packageName)) continue;
                this.scanPackageNames.add(packageName);
            }
        }
        return this;
    }

    public AccessorFactory build() {
        return this.build(true);
    }

    public AccessorFactory build(boolean scanPackage) {
        if (this.databaseConfigs.isEmpty()) {
            throw new QueryFlowException("you must configure a databse source");
        }
        this.buildAccessors();
        if (scanPackage) {
            this.buildPackage();
        }
        return AccessorManager.manager();
    }

    private void buildAccessors() {
        for (DatabaseConfig config : this.databaseConfigs) {
            if (config == null) continue;
            AccessorManager.buildAccessor(config);
        }
        Set<Map.Entry<String, DataSource>> entries = this.dataSources.entrySet();
        for (Map.Entry<String, DataSource> entry : entries) {
            AccessorManager.buildAccessor(entry.getKey(), entry.getValue());
        }
    }

    private void buildPackage() {
        ClassScanner.newScanner(this.toStringArray(this.scanPackageNames)).setFilter(clazz -> {
            if (clazz.getAnnotation(Mapper.class) != null) {
                MapperManager.addMapperClass(clazz);
            }
            return false;
        }).scan();
    }

    private String[] toStringArray(List<String> values) {
        if (values == null) {
            return null;
        }
        String[] strings = new String[values.size()];
        return values.toArray(strings);
    }
}

