/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor;

import com.queryflow.accessor.Accessor;
import com.queryflow.accessor.connection.DataExecutor;
import com.queryflow.accessor.statement.BatchStatement;
import com.queryflow.accessor.statement.CallStatement;
import com.queryflow.accessor.statement.PreparedBatchStatement;
import com.queryflow.accessor.statement.SelectStatement;
import com.queryflow.accessor.statement.UpdateStatement;
import com.queryflow.common.DbType;
import com.queryflow.common.QueryFlowException;
import com.queryflow.common.ResultMap;
import com.queryflow.common.TransactionLevel;
import com.queryflow.config.GlobalConfig;
import com.queryflow.log.Log;
import com.queryflow.log.LogFactory;
import com.queryflow.mapper.MapperManager;
import com.queryflow.page.PageSqlMatchProcess;
import com.queryflow.page.PageSqlProcessSelector;
import com.queryflow.page.Pager;
import com.queryflow.page.SimplePageSqlProcessSelector;
import com.queryflow.utils.Assert;
import com.queryflow.utils.JdbcUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DefaultAccessor
implements Accessor {
    private static final Log log = LogFactory.getLog(DefaultAccessor.class);
    private final DataExecutor executor;
    private final PageSqlProcessSelector pageSelector = new SimplePageSqlProcessSelector();
    private final DbType dbType;

    DefaultAccessor(DataSource dataSource) {
        Assert.notNull(dataSource);
        this.dbType = JdbcUtil.getDbType(dataSource);
        this.executor = new DataExecutor(dataSource);
    }

    @Override
    public DataSource getDataSource() {
        return this.executor.getDataSource();
    }

    @Override
    public UpdateStatement createUpdate(String sql) {
        return new UpdateStatement(sql, this.executor);
    }

    @Override
    public int update(String sql, Object ... values) {
        int rows = ((UpdateStatement)this.createUpdate(sql).bindArray(values)).execute();
        if (GlobalConfig.isCloseAfterExecuted()) {
            this.close();
        }
        return rows;
    }

    @Override
    public int update(String sql, List<Object> values) {
        int rows = ((UpdateStatement)this.createUpdate(sql).bindList(values)).execute();
        if (GlobalConfig.isCloseAfterExecuted()) {
            this.close();
        }
        return rows;
    }

    @Override
    public BatchStatement createBatch() {
        return new BatchStatement(this.executor);
    }

    @Override
    public int[] batch(String ... sqls) {
        return this.batch(Arrays.asList(sqls));
    }

    @Override
    public int[] batch(List<String> sqls) {
        BatchStatement batch = this.createBatch();
        if (sqls != null) {
            for (String sql : sqls) {
                batch.add(sql);
            }
            int[] rows = batch.execute();
            if (GlobalConfig.isCloseAfterExecuted()) {
                this.close();
            }
            return rows;
        }
        return new int[0];
    }

    @Override
    public PreparedBatchStatement prepareBatch(String sql) {
        return new PreparedBatchStatement(sql, this.executor);
    }

    @Override
    public int[] batch(String sql, List<List<Object>> values) {
        PreparedBatchStatement preparedBatch = this.prepareBatch(sql);
        if (values != null) {
            for (List<Object> value : values) {
                preparedBatch.add(value);
            }
            int[] rows = preparedBatch.execute();
            if (GlobalConfig.isCloseAfterExecuted()) {
                this.close();
            }
            return rows;
        }
        return new int[0];
    }

    @Override
    public SelectStatement createQuery(String sql) {
        return new SelectStatement(sql, this.executor);
    }

    @Override
    public SelectStatement query(String sql, Object ... values) {
        SelectStatement query = this.createQuery(sql);
        query.bindArray(values);
        return query;
    }

    @Override
    public SelectStatement query(String sql, List<Object> values) {
        SelectStatement query = new SelectStatement(sql, this.executor);
        query.bindList(values);
        return query;
    }

    @Override
    public Pager<ResultMap> pageToMap(String sql, List<Object> values, int page, int limit) {
        return this.page(sql, values, page, limit, ResultMap.class);
    }

    @Override
    public Pager<ResultMap> pageToMap(String sql, List<Object> values, int page) {
        return this.page(sql, values, page, 0, ResultMap.class);
    }

    @Override
    public <T> Pager<T> page(String sql, int page, int limit, Class<T> requiredType, Object ... values) {
        return this.page(sql, Arrays.asList(values), page, limit, requiredType);
    }

    @Override
    public <T> Pager<T> page(String sql, List<Object> values, int page, int limit, Class<T> requiredType) {
        int total = this.count(sql, values, false);
        PageSqlMatchProcess process = this.pageSelector.select(this.dbType.value());
        if (process == null) {
            throw new QueryFlowException("not support the database");
        }
        if (limit == 0) {
            limit = GlobalConfig.getDefaultPageLimit();
        }
        Pager<ResultMap> pager = new Pager<ResultMap>(total, page, limit, null);
        String pageSql = process.sqlProcess(sql, pager.getStart(), limit);
        SelectStatement query = (SelectStatement)this.createQuery(pageSql).bindList(values);
        List<ResultMap> records = Map.class.isAssignableFrom(requiredType) ? query.listMap() : query.list(requiredType);
        pager.setRecords(records);
        if (GlobalConfig.isCloseAfterExecuted()) {
            this.close();
        }
        return pager;
    }

    @Override
    public <T> Pager<T> page(String sql, List<Object> values, int page, Class<T> requiredType) {
        return this.page(sql, values, page, 0, requiredType);
    }

    @Override
    public int count(String sql, Object ... values) {
        return this.count(sql, Arrays.asList(values));
    }

    @Override
    public int count(String sql, List<Object> values) {
        return this.count(sql, values, GlobalConfig.isCloseAfterExecuted());
    }

    private int count(String sql, List<Object> params, boolean close) {
        Number number = ((SelectStatement)this.createQuery(this.getCountSql(sql)).bindList(params)).one(Number.class);
        if (close) {
            this.close();
        }
        return number != null ? number.intValue() : 0;
    }

    private String getCountSql(String sql) {
        PageSqlMatchProcess process = this.pageSelector.select(this.dbType.value());
        return process.getCountSql(sql);
    }

    @Override
    public CallStatement createCall(String sql) {
        return new CallStatement(sql, this.executor);
    }

    @Override
    public CallStatement call(String sql, Object ... values) {
        return (CallStatement)this.createCall(sql).bindArray(values);
    }

    @Override
    public CallStatement call(String sql, List<Object> values) {
        return (CallStatement)this.createCall(sql).bindList(values);
    }

    @Override
    public void openTransaction() {
        this.openTransaction(null);
    }

    @Override
    public void openTransaction(TransactionLevel level) {
        this.executor.openTransaction(level);
        log.info("opened a transaction in current thread");
    }

    @Override
    public void commit() {
        this.commit(true);
    }

    @Override
    public void commit(boolean close) {
        this.executor.commit();
        if (close) {
            this.executor.close();
            log.info("commit and close the connection");
        } else {
            log.info("commit the connection");
        }
    }

    @Override
    public void rollback() {
        this.rollback(true);
    }

    @Override
    public void rollback(boolean close) {
        this.executor.rollback();
        if (close) {
            this.executor.close();
            log.info("rollback and close the connection");
        } else {
            log.info("rollback the connection");
        }
    }

    @Override
    public <T> T getMapper(Class<T> clazz) {
        return MapperManager.getMapperClass(clazz);
    }

    @Override
    public void close() {
        this.executor.close();
    }
}

