/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.connection;

import com.queryflow.accessor.connection.ConnectionExecutor;
import com.queryflow.accessor.connection.ConnectionManager;
import com.queryflow.accessor.connection.TransactionManager;
import com.queryflow.accessor.handler.BeanListResultSetHandler;
import com.queryflow.accessor.handler.BeanResultSetHandler;
import com.queryflow.accessor.handler.MapListResultSetHandler;
import com.queryflow.accessor.handler.MapResultSetHandler;
import com.queryflow.accessor.handler.ResultSetHandler;
import com.queryflow.accessor.interceptor.Interceptors;
import com.queryflow.accessor.runner.BaseSqlRunner;
import com.queryflow.accessor.runner.SqlRunner;
import com.queryflow.common.QueryFlowException;
import com.queryflow.common.ResultMap;
import com.queryflow.common.TransactionLevel;
import com.queryflow.config.GlobalConfig;
import com.queryflow.log.Log;
import com.queryflow.log.LogFactory;
import com.queryflow.utils.SqlInterpolation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class DataExecutor
implements ConnectionManager,
ConnectionExecutor {
    private static final Log log = LogFactory.getLog(ConnectionManager.class);
    private final ThreadLocal<TransactionManager> CONN_CONTAINER = new ThreadLocal();
    private final DataSource dataSource;
    private final SqlRunner runner;
    private final SqlInterpolation interpolation = new SqlInterpolation();

    public DataExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
        this.runner = new BaseSqlRunner();
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Connection getConnection() {
        return this.getTransactionManager().getConnection();
    }

    private TransactionManager getTransactionManager() {
        return this.getTransactionManager(true);
    }

    private TransactionManager getTransactionManager(boolean create) {
        TransactionManager transactionManager = this.CONN_CONTAINER.get();
        try {
            if (create && (transactionManager == null || transactionManager.isClosed())) {
                transactionManager = new TransactionManager(this.getDataSource().getConnection());
                this.CONN_CONTAINER.set(transactionManager);
            }
        }
        catch (SQLException e) {
            throw new QueryFlowException(e);
        }
        return transactionManager;
    }

    @Override
    public void close() {
        TransactionManager transactionManager = this.getTransactionManager(false);
        if (transactionManager != null) {
            transactionManager.close();
        }
    }

    @Override
    public void openTransaction() {
        this.getTransactionManager().open();
    }

    @Override
    public void openTransaction(TransactionLevel level) {
        this.getTransactionManager().open(level);
    }

    @Override
    public void commit() {
        this.getTransactionManager().commit();
    }

    @Override
    public void rollback() {
        this.getTransactionManager().rollback();
    }

    @Override
    public int update(String sql, List<Object> params, Interceptors interceptors) {
        this.logMessage(sql, params);
        try {
            return this.runner.update(this.getConnection(), sql, params, interceptors);
        }
        catch (SQLException e) {
            log.error("update sql error: ", e);
            throw new QueryFlowException(e);
        }
    }

    @Override
    public <T> T insertGetKey(String sql, List<Object> params, String[] keyColumnNames, Interceptors interceptors, ResultSetHandler<T> handler) {
        this.logMessage(sql, params);
        try {
            return this.runner.insertGetKey(this.getConnection(), sql, params, keyColumnNames, interceptors, handler);
        }
        catch (SQLException e) {
            log.error("insert sql error: ", e);
            throw new QueryFlowException(e);
        }
    }

    @Override
    public <T> T batchInsertGetKes(String sql, List<List<Object>> params, String[] keyColumnNames, Interceptors interceptors, ResultSetHandler<T> handler) {
        if (GlobalConfig.isDebug()) {
            log.debug("batchUpdate insert sql is: " + sql);
        }
        try {
            return this.runner.batchInsertGetKeys(this.getConnection(), sql, params, keyColumnNames, interceptors, handler);
        }
        catch (SQLException e) {
            throw new QueryFlowException(e);
        }
    }

    @Override
    public int[] batchUpdate(List<String> sqls, Interceptors interceptors) {
        try {
            return this.runner.batch(this.getConnection(), sqls, interceptors);
        }
        catch (SQLException e) {
            throw new QueryFlowException(e);
        }
    }

    @Override
    public int[] batchUpdate(String sql, List<List<Object>> params, Interceptors interceptors) {
        if (GlobalConfig.isDebug()) {
            log.debug("the batchUpdate update sql is: " + sql);
        }
        try {
            return this.runner.batch(this.getConnection(), sql, params, interceptors);
        }
        catch (SQLException e) {
            log.error("batchUpdate update error: ", e);
            throw new QueryFlowException(e);
        }
    }

    @Override
    public <T> T query(String sql, List<Object> params, Interceptors interceptors, ResultSetHandler<T> handler) {
        this.logMessage(sql, params);
        try {
            return this.runner.query(this.getConnection(), sql, params, interceptors, handler);
        }
        catch (SQLException e) {
            log.error("execute sql error: ", e);
            throw new QueryFlowException(e);
        }
    }

    @Override
    public <T> T queryForBean(String sql, List<Object> params, Interceptors interceptors, Class<T> beanClass) {
        return this.query(sql, params, interceptors, BeanResultSetHandler.newBeanHandler(beanClass));
    }

    @Override
    public <T> List<T> queryForListBean(String sql, List<Object> params, Interceptors interceptors, Class<T> beanClass) {
        return (List)this.query(sql, params, interceptors, new BeanListResultSetHandler<T>(beanClass));
    }

    @Override
    public ResultMap queryForMap(String sql, List<Object> params, Interceptors interceptors) {
        return this.query(sql, params, interceptors, new MapResultSetHandler());
    }

    @Override
    public List<ResultMap> queryForListMap(String sql, List<Object> params, Interceptors interceptors) {
        return this.query(sql, params, interceptors, new MapListResultSetHandler());
    }

    @Override
    public int call(String sql, List<Object> params, Interceptors interceptors) {
        this.logMessage(sql, params);
        try {
            return this.runner.call(this.getConnection(), sql, params, interceptors);
        }
        catch (SQLException e) {
            log.error("execute sql error: ", e);
            throw new QueryFlowException(e);
        }
    }

    @Override
    public <T> T call(String sql, List<Object> params, Interceptors interceptors, ResultSetHandler<T> handler) {
        this.logMessage(sql, params);
        try {
            return this.runner.call(this.getConnection(), sql, params, interceptors, handler);
        }
        catch (SQLException e) {
            log.error("execute sql error: ", e);
            throw new QueryFlowException(e);
        }
    }

    private void logMessage(String sql, List<Object> params) {
        if (GlobalConfig.isDebug()) {
            log.debug("the execute sql is: " + sql);
            log.debug("the execute sql with values is: " + this.interpolation.convert(sql, params));
        }
    }
}

