/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.connection;

import com.queryflow.common.QueryFlowException;
import com.queryflow.common.TransactionLevel;
import com.queryflow.log.Log;
import com.queryflow.log.LogFactory;
import com.queryflow.utils.Assert;
import com.queryflow.utils.JdbcUtil;
import java.sql.Connection;
import java.sql.SQLException;

public class TransactionManager {
    private static final Log log = LogFactory.getLog(TransactionManager.class);
    private static final int STATUS_INIT = 0;
    private static final int STATUS_OPEN = 1;
    private static final int STATUS_COMMIT = 2;
    private static final int STATUS_ROLLBACK = 3;
    private int status;
    protected final Connection connection;

    TransactionManager(Connection connection) {
        Assert.notNull(connection);
        this.status = 0;
        this.connection = connection;
    }

    Connection getConnection() {
        return this.connection;
    }

    boolean isOpen() {
        return this.status == 1;
    }

    boolean isCommit() {
        return this.status == 2;
    }

    boolean isRollback() {
        return this.status == 3;
    }

    boolean isCompleted() {
        return this.status == 2 || this.status == 3;
    }

    boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new QueryFlowException(e);
        }
    }

    void open() {
        this.open(null);
    }

    void open(TransactionLevel level) {
        if (this.status == 0 || this.isCommit() || this.isRollback()) {
            try {
                this.connection.setAutoCommit(false);
                if (level != null && level.getValue() != this.connection.getTransactionIsolation()) {
                    this.connection.setTransactionIsolation(level.getValue());
                }
                this.status = 1;
            }
            catch (SQLException e) {
                throw new QueryFlowException(e);
            }
        }
    }

    void close() {
        if (this.isClosed()) {
            log.debug("the connection has been closed");
            return;
        }
        if (this.isOpen()) {
            try {
                this.connection.commit();
                this.connection.close();
            }
            catch (SQLException e) {
                throw new QueryFlowException(e);
            }
        } else {
            JdbcUtil.close(this.connection);
        }
    }

    void commit() {
        if (this.isClosed()) {
            log.debug("the connection has been closed");
            return;
        }
        if (this.isOpen()) {
            try {
                this.connection.commit();
                this.status = 2;
                log.debug("commit success");
            }
            catch (SQLException e) {
                throw new QueryFlowException(e);
            }
        }
    }

    void rollback() {
        if (this.isClosed()) {
            log.debug("the connection has been closed");
            return;
        }
        if (this.isOpen()) {
            try {
                this.connection.rollback();
                this.status = 3;
            }
            catch (SQLException e) {
                throw new QueryFlowException(e);
            }
        }
    }
}

