/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.handler;

import com.queryflow.accessor.handler.ResultSetHandler;
import com.queryflow.cache.impl.LRUCache;
import com.queryflow.config.GlobalConfig;
import com.queryflow.reflection.ReflectionUtil;
import com.queryflow.reflection.Reflector;
import com.queryflow.reflection.invoker.FieldInvoker;
import com.queryflow.utils.JdbcUtil;
import com.queryflow.utils.Utils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BeanResultSetHandler<T>
implements ResultSetHandler {
    private static final LRUCache<Class<?>, BeanResultSetHandler> BEAN_HANDLER_CACHE = new LRUCache(20);
    private final Class<T> beanType;
    private final boolean isCommonClass;
    private Map<String, FieldInvoker> invokers;

    public static <R> BeanResultSetHandler<R> newBeanHandler(Class<R> requiredType) {
        if (requiredType == null) {
            throw new NullPointerException("the requiredType must not be null");
        }
        if (Utils.isPrimitiveOrWrapper(requiredType) || String.class.equals(requiredType)) {
            return new BeanResultSetHandler<R>(requiredType);
        }
        BeanResultSetHandler<R> handler = BEAN_HANDLER_CACHE.getValue(requiredType);
        if (handler == null) {
            handler = new BeanResultSetHandler<R>(requiredType);
            BEAN_HANDLER_CACHE.putValue(requiredType, handler);
        }
        return handler;
    }

    private BeanResultSetHandler(Class<T> type) {
        this.beanType = type;
        if (JdbcUtil.isJdbcCommonClass(type)) {
            this.isCommonClass = true;
        } else {
            this.isCommonClass = false;
            this.invokers = new HashMap<String, FieldInvoker>();
            Object reflector = ReflectionUtil.forEntityClass(type);
            boolean camelCaseToSnake = GlobalConfig.isCamelCaseToSnake();
            Iterator<FieldInvoker> iterator = ((Reflector)reflector).fieldIterator();
            while (iterator.hasNext()) {
                String lineUpperName;
                FieldInvoker fieldInvoker = iterator.next();
                String name = fieldInvoker.getName();
                this.invokers.put(name, fieldInvoker);
                String upperName = name.toUpperCase();
                if (!name.equals(upperName)) {
                    this.invokers.put(upperName, fieldInvoker);
                }
                if (!camelCaseToSnake) continue;
                String lineName = Utils.camelCaseToSnake(name);
                if (!this.invokers.containsKey(lineName)) {
                    this.invokers.put(lineName, fieldInvoker);
                }
                if (this.invokers.containsKey(lineUpperName = lineName.toUpperCase())) continue;
                this.invokers.put(lineUpperName, fieldInvoker);
            }
        }
    }

    @Override
    public T handle(ResultSet rs) throws SQLException {
        return this.handle(rs, true);
    }

    T handle(ResultSet rs, boolean next) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int colCount = metaData.getColumnCount();
        if (colCount == 0) {
            return null;
        }
        boolean hasNext = next ? rs.next() : true;
        if (hasNext) {
            if (this.isCommonClass) {
                return (T)JdbcUtil.getResultSetValue(rs, 1, this.beanType);
            }
            T result = Utils.instantiate(this.beanType);
            for (int i = 1; i <= colCount; ++i) {
                String columnName = JdbcUtil.getColumnName(metaData, i);
                FieldInvoker fieldInvoker = this.invokers.get(columnName);
                if (fieldInvoker == null) continue;
                Object value = JdbcUtil.getResultSetValue(rs, i, fieldInvoker.getType());
                fieldInvoker.setValue(result, value);
            }
            return result;
        }
        return null;
    }
}

