/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.interceptor;

import com.queryflow.accessor.interceptor.Interceptor;
import com.queryflow.accessor.interceptor.Interceptors;
import com.queryflow.accessor.statement.StatementInitConfig;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public final class InterceptorHelper {
    private InterceptorHelper() {
    }

    public static Statement statement(Connection conn, Interceptors interceptors) throws SQLException {
        StatementInitConfig config = null;
        if (interceptors != null) {
            config = interceptors.getStatementInitConfig();
        }
        Statement statement = config != null && config.resultSetType != null && config.resultSetConcurType != null ? conn.createStatement(config.resultSetType.value(), config.resultSetConcurType.value()) : conn.createStatement();
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, String[] keyColumnNames, Interceptors interceptors, boolean returnKeys) throws SQLException {
        StatementInitConfig config = null;
        if (interceptors != null) {
            config = interceptors.getStatementInitConfig();
        }
        PreparedStatement ps = returnKeys ? (keyColumnNames != null && keyColumnNames.length > 0 ? conn.prepareStatement(sql, keyColumnNames) : conn.prepareStatement(sql, 1)) : (config != null && config.resultSetType != null && config.resultSetConcurType != null ? conn.prepareStatement(sql, config.resultSetType.value(), config.resultSetConcurType.value()) : conn.prepareStatement(sql));
        return ps;
    }

    public static CallableStatement prepareCall(Connection conn, String sql, Interceptors interceptors) throws SQLException {
        StatementInitConfig config = null;
        if (interceptors != null) {
            config = interceptors.getStatementInitConfig();
        }
        CallableStatement cs = config != null && config.resultSetType != null && config.resultSetConcurType != null ? conn.prepareCall(sql, config.resultSetType.value(), config.resultSetConcurType.value()) : conn.prepareCall(sql);
        return cs;
    }

    public static boolean before(Interceptors interceptors, Statement statement) throws SQLException {
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors.getInterceptors()) {
                if (interceptor.beforeExecution(statement)) continue;
                return false;
            }
        }
        return true;
    }

    public static void after(Interceptors interceptors, Statement statement) throws SQLException {
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors.getInterceptors()) {
                interceptor.afterExecution(statement);
            }
        }
    }
}

