/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.interceptor;

import com.queryflow.accessor.interceptor.Interceptor;
import com.queryflow.common.FetchDirection;
import java.sql.SQLException;
import java.sql.Statement;

public final class StatementInterceptors {
    private StatementInterceptors() {
    }

    public static Interceptor maxFieldSize(final int max) {
        return new Interceptor(){

            @Override
            public boolean beforeExecution(Statement statement) throws SQLException {
                statement.setMaxFieldSize(max);
                return true;
            }
        };
    }

    public static Interceptor queryTimeout(final int seconds) {
        return new Interceptor(){

            @Override
            public boolean beforeExecution(Statement statement) throws SQLException {
                statement.setQueryTimeout(seconds);
                return true;
            }
        };
    }

    public static Interceptor fetchSize(final int rows) {
        return new Interceptor(){

            @Override
            public boolean beforeExecution(Statement statement) throws SQLException {
                statement.setFetchSize(rows);
                return true;
            }
        };
    }

    public static Interceptor fetchDirection(final FetchDirection direction) {
        return new Interceptor(){

            @Override
            public boolean beforeExecution(Statement statement) throws SQLException {
                statement.setFetchDirection(direction.value());
                return true;
            }
        };
    }

    public static Interceptor maxRows(final int maxRows) {
        return new Interceptor(){

            @Override
            public boolean beforeExecution(Statement statement) throws SQLException {
                statement.setMaxRows(maxRows);
                return true;
            }
        };
    }
}

