/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.runner;

import com.queryflow.accessor.handler.ResultSetHandler;
import com.queryflow.accessor.interceptor.InterceptorHelper;
import com.queryflow.accessor.interceptor.Interceptors;
import com.queryflow.accessor.runner.AbstractSqlRunner;
import com.queryflow.accessor.runner.OutParameter;
import com.queryflow.utils.JdbcUtil;
import com.queryflow.utils.Utils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BaseSqlRunner
extends AbstractSqlRunner {
    @Override
    public <T> T query(Connection conn, String sql, List<Object> params, Interceptors interceptors, ResultSetHandler<T> handler) throws SQLException {
        T result;
        ResultSet rs;
        PreparedStatement ps;
        block6: {
            this.check(conn, sql);
            ps = null;
            rs = null;
            result = null;
            ps = this.prepareStatement(conn, sql, null, interceptors, false);
            this.fillStatement(ps, params);
            if (InterceptorHelper.before(interceptors, ps)) break block6;
            T t = null;
            JdbcUtil.close(rs, ps);
            return t;
        }
        try {
            rs = ps.executeQuery();
            InterceptorHelper.after(interceptors, ps);
            if (handler != null) {
                result = handler.handle(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLException(this.buildErrorMessage(e, sql, params), e.getSQLState(), e.getErrorCode());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs, ps);
                throw throwable;
            }
        }
        JdbcUtil.close(rs, ps);
        return result;
    }

    @Override
    public int update(Connection conn, String sql, List<Object> params, Interceptors interceptors) throws SQLException {
        int rows;
        PreparedStatement ps;
        block5: {
            this.check(conn, sql);
            ps = null;
            ps = this.prepareStatement(conn, sql, null, interceptors, false);
            this.fillStatement(ps, params);
            if (InterceptorHelper.before(interceptors, ps)) break block5;
            int n = 0;
            JdbcUtil.close(ps);
            return n;
        }
        try {
            rows = ps.executeUpdate();
            InterceptorHelper.after(interceptors, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException(this.buildErrorMessage(e, sql, params), e.getSQLState(), e.getErrorCode());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(ps);
                throw throwable;
            }
        }
        JdbcUtil.close(ps);
        return rows;
    }

    @Override
    public <T> T insertGetKey(Connection conn, String sql, List<Object> params, String[] keyColumnNames, Interceptors interceptors, ResultSetHandler<T> handler) throws SQLException {
        T result;
        ResultSet rs;
        PreparedStatement ps;
        block6: {
            this.check(conn, sql);
            ps = null;
            rs = null;
            result = null;
            ps = this.prepareStatement(conn, sql, keyColumnNames, interceptors, true);
            this.fillStatement(ps, params);
            if (InterceptorHelper.before(interceptors, ps)) break block6;
            T t = null;
            JdbcUtil.close(rs, ps);
            return t;
        }
        try {
            ps.execute();
            InterceptorHelper.after(interceptors, ps);
            if (handler != null) {
                rs = ps.getGeneratedKeys();
                result = handler.handle(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLException(this.buildErrorMessage(e, sql, params), e.getSQLState(), e.getErrorCode());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs, ps);
                throw throwable;
            }
        }
        JdbcUtil.close(rs, ps);
        return result;
    }

    @Override
    public <T> T batchInsertGetKeys(Connection conn, String sql, List<List<Object>> params, String[] keyColumnNames, Interceptors interceptors, ResultSetHandler<T> handler) throws SQLException {
        T result;
        ResultSet rs;
        PreparedStatement ps;
        block8: {
            this.check(conn, sql);
            if (params == null) {
                params = new ArrayList<List<Object>>(0);
            }
            ps = null;
            rs = null;
            result = null;
            ps = this.prepareStatement(conn, sql, keyColumnNames, interceptors, true);
            int len = params.size();
            for (int i = 0; i < len; ++i) {
                this.fillStatement(ps, params.get(i));
                ps.addBatch();
            }
            if (InterceptorHelper.before(interceptors, ps)) break block8;
            T i = null;
            JdbcUtil.close(rs, ps);
            return i;
        }
        try {
            ps.executeBatch();
            InterceptorHelper.after(interceptors, ps);
            if (handler != null) {
                rs = ps.getGeneratedKeys();
                result = handler.handle(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLException(this.buildErrorMessage(e, sql, null), e.getSQLState(), e.getErrorCode());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs, ps);
                throw throwable;
            }
        }
        JdbcUtil.close(rs, ps);
        return result;
    }

    @Override
    public int[] batch(Connection conn, String sql, List<List<Object>> params, Interceptors interceptors) throws SQLException {
        int[] rows;
        PreparedStatement ps;
        block7: {
            this.check(conn, sql);
            if (params == null) {
                params = new ArrayList<List<Object>>(0);
            }
            ps = null;
            rows = new int[]{};
            ps = this.prepareStatement(conn, sql, null, interceptors, false);
            int len = params.size();
            for (int i = 0; i < len; ++i) {
                this.fillStatement(ps, params.get(i));
                ps.addBatch();
            }
            if (InterceptorHelper.before(interceptors, ps)) break block7;
            int[] i = rows;
            JdbcUtil.close(ps);
            return i;
        }
        try {
            rows = ps.executeBatch();
            InterceptorHelper.after(interceptors, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException(this.buildErrorMessage(e, sql, null), e.getSQLState(), e.getErrorCode());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(ps);
                throw throwable;
            }
        }
        JdbcUtil.close(ps);
        return rows;
    }

    @Override
    public int[] batch(Connection conn, List<String> sqls, Interceptors interceptors) throws SQLException {
        int[] rows;
        Statement statement;
        block8: {
            if (conn == null) {
                throw new SQLException("the connection is null");
            }
            if (sqls == null || sqls.isEmpty()) {
                throw new SQLException("sql statements is null");
            }
            statement = null;
            rows = new int[]{};
            statement = this.statement(conn, interceptors);
            if (InterceptorHelper.before(interceptors, statement)) break block8;
            int[] nArray = rows;
            JdbcUtil.close(statement);
            return nArray;
        }
        try {
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            rows = statement.executeBatch();
            InterceptorHelper.after(interceptors, statement);
        }
        catch (SQLException e) {
            try {
                throw new SQLException(this.buildErrorMessage(e, "", null), e.getSQLState(), e.getErrorCode());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(statement);
                throw throwable;
            }
        }
        JdbcUtil.close(statement);
        return rows;
    }

    @Override
    public int call(Connection conn, String sql, List<Object> params, Interceptors interceptors) throws SQLException {
        int rows;
        CallableStatement cs;
        block5: {
            this.check(conn, sql);
            cs = null;
            rows = 0;
            cs = this.prepareCall(conn, sql, interceptors);
            if (InterceptorHelper.before(interceptors, cs)) break block5;
            int n = rows;
            JdbcUtil.close(cs);
            return n;
        }
        try {
            this.fillStatement(cs, params);
            rows = cs.executeUpdate();
            InterceptorHelper.after(interceptors, cs);
            this.setOutParameterValue(cs, params);
        }
        catch (SQLException e) {
            try {
                throw new SQLException(this.buildErrorMessage(e, sql, params), e.getSQLState(), e.getErrorCode());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(cs);
                throw throwable;
            }
        }
        JdbcUtil.close(cs);
        return rows;
    }

    @Override
    public <T> T call(Connection conn, String sql, List<Object> params, Interceptors interceptors, ResultSetHandler<T> handler) throws SQLException {
        T result;
        ResultSet rs;
        CallableStatement cs;
        block6: {
            this.check(conn, sql);
            cs = null;
            rs = null;
            result = null;
            cs = this.prepareCall(conn, sql, interceptors);
            this.fillStatement(cs, params);
            if (InterceptorHelper.before(interceptors, cs)) break block6;
            T t = null;
            JdbcUtil.close(rs, cs);
            return t;
        }
        try {
            cs.execute();
            InterceptorHelper.after(interceptors, cs);
            rs = cs.getResultSet();
            if (handler != null) {
                result = handler.handle(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLException(this.buildErrorMessage(e, sql, params), e.getSQLState(), e.getErrorCode());
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs, cs);
                throw throwable;
            }
        }
        JdbcUtil.close(rs, cs);
        return result;
    }

    private void check(Connection conn, String sql) throws SQLException {
        if (conn == null) {
            throw new SQLException("the connection is null");
        }
        if (Utils.isEmpty(sql)) {
            throw new SQLException("sql sql is null");
        }
    }

    private void setOutParameterValue(CallableStatement cs, List<Object> params) throws SQLException {
        if (params != null) {
            int len = params.size();
            for (int i = 0; i < len; ++i) {
                Object param = params.get(i);
                if (!(param instanceof OutParameter)) continue;
                ((OutParameter)param).setValue(cs, i + 1);
            }
        }
    }
}

