/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.statement;

import com.queryflow.accessor.connection.ConnectionExecutor;
import com.queryflow.accessor.handler.BeanListResultSetHandler;
import com.queryflow.accessor.handler.BeanResultSetHandler;
import com.queryflow.accessor.handler.MapListResultSetHandler;
import com.queryflow.accessor.handler.MapResultSetHandler;
import com.queryflow.accessor.handler.ResultSetHandler;
import com.queryflow.accessor.runner.OutParameter;
import com.queryflow.accessor.statement.OutParameters;
import com.queryflow.accessor.statement.SelectBaseStatement;
import com.queryflow.common.DataType;
import com.queryflow.common.ResultMap;
import java.util.List;

public class CallStatement
extends SelectBaseStatement<CallStatement> {
    private final OutParameters parameters = new OutParameters();

    public CallStatement(String sql, ConnectionExecutor executor) {
        super(sql, executor);
    }

    public CallStatement registerOutParameter(String name, DataType dataType) {
        if (dataType != null) {
            OutParameter outParameter = new OutParameter(dataType);
            this.parameters.putParameter(name, outParameter);
            this.params.add(outParameter);
        }
        return this;
    }

    public CallStatement registerOutParameter(String name, OutParameter outParameter) {
        if (outParameter != null) {
            this.parameters.putParameter(name, outParameter);
            this.params.add(outParameter);
        }
        return this;
    }

    public OutParameters execute() {
        this.internalExecute();
        this.parameters.updateRows = this.executor.call(this.sql, this.params, this.interceptors);
        return this.parameters;
    }

    @Override
    public <T> T one(Class<T> type) {
        this.internalExecute();
        return this.executor.call(this.sql, this.params, this.interceptors, BeanResultSetHandler.newBeanHandler(type));
    }

    @Override
    public ResultMap oneMap() {
        this.internalExecute();
        return this.executor.call(this.sql, this.params, this.interceptors, new MapResultSetHandler());
    }

    @Override
    public <T> List<T> list(Class<T> type) {
        this.internalExecute();
        return (List)this.executor.call(this.sql, this.params, this.interceptors, new BeanListResultSetHandler<T>(type));
    }

    @Override
    public List<ResultMap> listMap() {
        this.internalExecute();
        return this.executor.call(this.sql, this.params, this.interceptors, new MapListResultSetHandler());
    }

    @Override
    public <T> T result(ResultSetHandler<T> handler) {
        this.internalExecute();
        return this.executor.call(this.sql, this.params, this.interceptors, handler);
    }
}

