/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.statement;

import com.queryflow.accessor.runner.OutParameter;
import com.queryflow.utils.Converts;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class OutParameters {
    private Map<String, OutParameter> parameters = new LinkedHashMap<String, OutParameter>();
    int updateRows = 0;

    public Collection<OutParameter> getAllParameters() {
        return this.parameters.values();
    }

    public void putParameter(String name, OutParameter outParameter) {
        this.parameters.put(name, outParameter);
    }

    public OutParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public int getUpdateRows() {
        return this.updateRows;
    }

    public Object getObject(String name) {
        OutParameter parameter = this.getParameter(name);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    public String getString(String name) {
        return Converts.toStr(this.getObject(name), null);
    }

    public String getString(String name, String defaultValue) {
        return Converts.toStr(this.getObject(name), defaultValue);
    }

    public Character getCharacter(String name) {
        return Converts.toCharacter(this.getObject(name), null);
    }

    public Character getCharacter(String name, Character defaultValue) {
        return Converts.toCharacter(this.getObject(name), defaultValue);
    }

    public Boolean getBoolean(String name) {
        return Converts.toBoolean(this.getObject(name), null);
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        return Converts.toBoolean(this.getObject(name), defaultValue);
    }

    public Byte getByte(String name) {
        return Converts.toByte(this.getObject(name), null);
    }

    public Byte getByte(String name, Byte defaultValue) {
        return Converts.toByte(this.getObject(name), defaultValue);
    }

    public Short getShort(String name) {
        return Converts.toShort(this.getObject(name), null);
    }

    public Short getShort(String name, Short defaultValue) {
        return Converts.toShort(this.getObject(name), defaultValue);
    }

    public Integer getInteger(String name) {
        return Converts.toInteger(this.getObject(name), null);
    }

    public Integer getInteger(String name, Integer defaultValue) {
        return Converts.toInteger(this.getObject(name), defaultValue);
    }

    public Long getLong(String name) {
        return Converts.toLong(this.getObject(name), null);
    }

    public Long getLong(String name, Long defaultValue) {
        return Converts.toLong(this.getObject(name), defaultValue);
    }

    public Float getFloat(String name) {
        return Converts.toFloat(this.getObject(name), null);
    }

    public Float getFloat(String name, Float defaultValue) {
        return Converts.toFloat(this.getObject(name), defaultValue);
    }

    public Double getDouble(String name) {
        return Converts.toDouble(this.getObject(name), null);
    }

    public Double getDouble(String name, Double defaultValue) {
        return Converts.toDouble(this.getObject(name), defaultValue);
    }

    public byte[] getBytes(String name) {
        return Converts.toBytes(this.getObject(name), new byte[0]);
    }

    public byte[] getBytes(String name, byte[] defaultValue) {
        return Converts.toBytes(this.getObject(name), defaultValue);
    }

    public BigDecimal getBigDecimal(String name) {
        return Converts.toBigDecimal(this.getObject(name), null);
    }

    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        return Converts.toBigDecimal(this.getObject(name), defaultValue);
    }

    public java.sql.Date getDate(String name) {
        return Converts.toDate(this.getObject(name), null);
    }

    public java.sql.Date getDate(String name, java.sql.Date defaultValue) {
        return Converts.toDate(this.getObject(name), defaultValue);
    }

    public Time getTime(String name) {
        return Converts.toTime(this.getObject(name), null);
    }

    public Time getTime(String name, Time defaultValue) {
        return Converts.toTime(this.getObject(name), defaultValue);
    }

    public Timestamp getTimestamp(String name) {
        return Converts.toTimestamp(this.getObject(name), null);
    }

    public Timestamp getTimestamp(String name, Timestamp defaultValue) {
        return Converts.toTimestamp(this.getObject(name), defaultValue);
    }

    public Date getUtilDate(String name, String pattern) {
        return Converts.toUtilDate(this.getObject(name), pattern, null);
    }

    public Date getUtilDate(String name, String pattern, Date defaultValue) {
        return Converts.toUtilDate(this.getObject(name), pattern, defaultValue);
    }

    public Clob getClob(String name) {
        return Converts.toClob(this.getObject(name), null);
    }

    public Clob getClob(String name, Clob defaultValue) {
        return Converts.toClob(this.getObject(name), defaultValue);
    }

    public Blob getBlob(String name) {
        return Converts.toBlob(this.getObject(name), null);
    }

    public Blob getBlob(String name, Blob defaultValue) {
        return Converts.toBlob(this.getObject(name), defaultValue);
    }
}

