/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.statement;

import com.queryflow.accessor.connection.ConnectionExecutor;
import com.queryflow.accessor.statement.BaseStatement;
import com.queryflow.accessor.statement.KeysResultSetHandler;
import com.queryflow.common.ResultMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class PreparedBatchStatement
extends BaseStatement<PreparedBatchStatement> {
    private final List<List<Object>> values = new LinkedList<List<Object>>();

    public PreparedBatchStatement(String sql, ConnectionExecutor executor) {
        super(sql, executor);
    }

    public PreparedBatchStatement add() {
        this.values.add(new LinkedList(this.params));
        this.params.clear();
        return this;
    }

    public PreparedBatchStatement add(List<Object> params) {
        this.values.add(new LinkedList<Object>(params));
        return this;
    }

    public PreparedBatchStatement add(Object ... params) {
        this.values.add(Arrays.asList(params));
        return this;
    }

    public int size() {
        return this.values.size();
    }

    public int[] execute() {
        this.internalExecute();
        return this.executor.batchUpdate(this.sql, this.values, this.interceptors);
    }

    public List<ResultMap> executeAndReturnGeneratedKeys(String ... columnNames) {
        this.internalExecute();
        return this.executor.batchInsertGetKes(this.sql, this.values, columnNames, this.interceptors, new KeysResultSetHandler(columnNames));
    }
}

