/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.accessor.statement;

import com.queryflow.accessor.connection.ConnectionExecutor;
import com.queryflow.accessor.handler.ResultSetHandler;
import com.queryflow.accessor.interceptor.StatementInterceptors;
import com.queryflow.accessor.statement.BaseStatement;
import com.queryflow.common.FetchDirection;
import com.queryflow.common.ResultMap;
import com.queryflow.common.ResultSetConcurType;
import java.util.List;

public abstract class SelectBaseStatement<T extends SelectBaseStatement>
extends BaseStatement<T> {
    SelectBaseStatement(String sql, ConnectionExecutor executor) {
        super(sql, executor);
    }

    public T concurrentUpdatable() {
        this.statementInitConfig.resultSetConcurType = ResultSetConcurType.UPDATABLE;
        return (T)this;
    }

    public T setMaxFieldSize(int max) {
        this.interceptors.registerInterceptor(StatementInterceptors.maxFieldSize(max));
        return (T)this;
    }

    public T setFetchSize(int rows) {
        this.interceptors.registerInterceptor(StatementInterceptors.fetchSize(rows));
        return (T)this;
    }

    public T setFetchDirection(FetchDirection direction) {
        this.interceptors.registerInterceptor(StatementInterceptors.fetchDirection(direction));
        return (T)this;
    }

    public T setMaxRows(int rows) {
        this.interceptors.registerInterceptor(StatementInterceptors.maxRows(rows));
        return (T)this;
    }

    public abstract <R> R one(Class<R> var1);

    public abstract ResultMap oneMap();

    public abstract <R> List<R> list(Class<R> var1);

    public abstract List<ResultMap> listMap();

    public abstract <R> R result(ResultSetHandler<R> var1);
}

