/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.cache;

import com.queryflow.cache.ValueObject;
import java.util.Iterator;
import java.util.Map;

public class CacheIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final Iterator<Map.Entry<K, ? extends ValueObject<K, V>>> iterator;

    public CacheIterator(Iterator<Map.Entry<K, ? extends ValueObject<K, V>>> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Map.Entry<K, V> next() {
        Map.Entry<K, ValueObject<K, V>> next = this.iterator.next();
        return new CacheEntry<K, V>(next.getKey(), next.getValue().get());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("this is a read-only iterator, cannot use remove opration.");
    }

    private class CacheEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        CacheEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("");
        }
    }
}

