/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.cache.impl;

import com.queryflow.cache.Cache;
import com.queryflow.cache.CacheIterator;
import com.queryflow.cache.ValueObject;
import com.queryflow.utils.Assert;
import com.queryflow.utils.CopiedIterator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCache<K, V>
extends LinkedHashMap<K, ValueObject<K, V>>
implements Cache<K, V> {
    private static final int DEFAULT_MAX_SIZE = 300;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final int maxSize;

    public LRUCache() {
        this(300);
    }

    public LRUCache(int maxSize) {
        super(16, 0.75f, false);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, ValueObject<K, V>> eldest) {
        return this.size() > this.maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int size() {
        try {
            this.readLock.lock();
            int n = super.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V getValue(K key) {
        Object valueObject = this.get(key);
        return valueObject == null ? null : (V)((ValueObject)valueObject).get();
    }

    @Override
    public ValueObject<K, V> get(Object key) {
        Assert.notNull(key, "the key must not be null");
        try {
            this.readLock.lock();
            ValueObject valueObject = (ValueObject)super.get(key);
            return valueObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isFull() {
        try {
            this.readLock.lock();
            boolean bl = this.size() >= this.maxSize;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.readLock.lock();
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void putValue(K key, V value) {
        Assert.notNull(value);
        this.put(key, new ValueObject<K, V>(key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueObject<K, V> put(K key, ValueObject<K, V> value) {
        Assert.notNull(key);
        Assert.notNull(value);
        try {
            this.writeLock.lock();
            ValueObject<K, V> valueObject = super.put(key, value);
            return valueObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putValues(Cache<K, V> cache) {
        if (cache == null) {
            return;
        }
        try {
            this.writeLock.lock();
            for (Map.Entry entry : cache) {
                Object key = entry.getKey();
                super.put(key, new ValueObject(key, entry.getValue()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends ValueObject<K, V>> m) {
        if (m == null) {
            return;
        }
        try {
            this.writeLock.lock();
            super.putAll(m);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V removeValue(K key) {
        Object removedValue = this.remove(key);
        return removedValue == null ? null : (V)((ValueObject)removedValue).get();
    }

    @Override
    public ValueObject<K, V> remove(Object key) {
        if (key == null) {
            return null;
        }
        try {
            this.writeLock.lock();
            ValueObject valueObject = (ValueObject)super.remove(key);
            return valueObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clearValues() {
        this.clear();
    }

    @Override
    public void clear() {
        try {
            this.writeLock.lock();
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        try {
            this.readLock.lock();
            Iterator iterator = this.entrySet().iterator();
            CopiedIterator copiedIterator = new CopiedIterator(iterator);
            CacheIterator cacheIterator = new CacheIterator(copiedIterator);
            return cacheIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

