/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.config;

import com.queryflow.key.KeyGenerateUtil;
import com.queryflow.key.KeyGenerator;

public class GlobalConfig {
    private long workerId = 1L;
    private long dataCenterId = 1L;
    private boolean camelCaseToSnake = true;
    private boolean debug = false;
    private int defaultPageLimit = 10;
    private int queryTimeout = 0;
    private int queryMaxRows = 0;
    private int maxFieldSize = 0;
    private boolean closeAfterExecuted = false;

    private GlobalConfig() {
    }

    public static GlobalConfig configer() {
        return InstanceHolder.INSTANCE;
    }

    public static long getWorkerId() {
        return GlobalConfig.configer().workerId;
    }

    public static long getDataCenterId() {
        return GlobalConfig.configer().dataCenterId;
    }

    public static boolean isCamelCaseToSnake() {
        return GlobalConfig.configer().camelCaseToSnake;
    }

    public static boolean isDebug() {
        return GlobalConfig.configer().debug;
    }

    public static int getDefaultPageLimit() {
        return GlobalConfig.configer().defaultPageLimit;
    }

    public static int getQueryTimeout() {
        return GlobalConfig.configer().queryTimeout;
    }

    public static int getQueryMaxRows() {
        return GlobalConfig.configer().queryMaxRows;
    }

    public static int getMaxFieldSize() {
        return GlobalConfig.configer().maxFieldSize;
    }

    public static boolean isCloseAfterExecuted() {
        return GlobalConfig.configer().closeAfterExecuted;
    }

    public GlobalConfig setWorkerId(long id) {
        if (id >= 0L) {
            this.workerId = id;
        }
        return this;
    }

    public GlobalConfig setDataCenterId(long id) {
        if (id > 0L) {
            this.dataCenterId = id;
        }
        return this;
    }

    public GlobalConfig camelCaseToSnake(boolean convert) {
        this.camelCaseToSnake = convert;
        return this;
    }

    public GlobalConfig registerKeyGenerator(Class<? extends KeyGenerator> clazz) {
        KeyGenerateUtil.registerKeyGenerator(clazz);
        return this;
    }

    public GlobalConfig debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public GlobalConfig defaultPageLimit(int defaultPageLimit) {
        if (defaultPageLimit > 0) {
            this.defaultPageLimit = defaultPageLimit;
        }
        return this;
    }

    public GlobalConfig queryTimeout(int seconds) {
        if (seconds >= 0) {
            this.queryTimeout = seconds;
        }
        return this;
    }

    public GlobalConfig queryMaxRows(int max) {
        if (max >= 0) {
            this.queryMaxRows = max;
        }
        return this;
    }

    public GlobalConfig maxFieldSize(int max) {
        if (max >= 0) {
            this.maxFieldSize = max;
        }
        return this;
    }

    public GlobalConfig closeAfterExecuted(boolean close) {
        this.closeAfterExecuted = close;
        return this;
    }

    private static class InstanceHolder {
        private static final GlobalConfig INSTANCE = new GlobalConfig();

        private InstanceHolder() {
        }
    }
}

