/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.config.parser;

import com.queryflow.common.QueryFlowException;
import com.queryflow.config.DatabaseConfig;
import com.queryflow.config.parser.AbstractConfigFileParser;
import com.queryflow.config.parser.ConfigFileRunner;
import com.queryflow.config.parser.PropertiesConfigFileParser;
import com.queryflow.config.parser.YamlConfigFileParser;
import com.queryflow.utils.Utils;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class ConfigFileFactory {
    private static final String DEFAULT_CONFIG_FILE_YAML = "/queryflow.yaml";
    private static final String DEFAULT_CONFIG_FILE_YML = "/queryflow.yml";
    private static final String DEFAULT_CONFIG_FILE_PROPERTIES = "/queryflow.properties";

    private ConfigFileFactory() {
    }

    public static List<DatabaseConfig> parseConfigFile(String path) {
        AbstractConfigFileParser fileParser;
        File configFile;
        if (Utils.isEmpty(path)) {
            URL resource = ConfigFileFactory.class.getResource(DEFAULT_CONFIG_FILE_YAML);
            if (resource == null) {
                resource = ConfigFileFactory.class.getResource(DEFAULT_CONFIG_FILE_YML);
            }
            if (resource == null) {
                resource = ConfigFileFactory.class.getResource(DEFAULT_CONFIG_FILE_PROPERTIES);
            }
            if (resource == null) {
                throw new QueryFlowException("the config file not found, default queryflow.yaml or queryflow.properties");
            }
            configFile = new File(resource.getFile());
        } else {
            configFile = new File(path);
            if (!configFile.exists()) {
                throw new QueryFlowException("the config file not found, file: " + path);
            }
        }
        String fileName = configFile.getName();
        if (fileName.endsWith(".yaml")) {
            fileParser = new YamlConfigFileParser();
        } else if (fileName.endsWith(".properties")) {
            fileParser = new PropertiesConfigFileParser();
        } else {
            throw new QueryFlowException("unknow type of file");
        }
        ConfigFileRunner runner = new ConfigFileRunner();
        return runner.run((Map)fileParser.parse(configFile));
    }
}

