/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.config.parser;

import com.queryflow.config.DatabaseConfig;
import com.queryflow.config.GlobalConfig;
import com.queryflow.reflection.Reflector;
import com.queryflow.reflection.invoker.FieldInvoker;
import com.queryflow.utils.Converts;
import com.queryflow.utils.Utils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class ConfigFileRunner {
    ConfigFileRunner() {
    }

    List<DatabaseConfig> run(Map<String, Object> config) {
        GlobalConfig globalConfig = GlobalConfig.configer();
        globalConfig.setWorkerId(Converts.toLong(config.get("workerId"), 1L));
        globalConfig.setDataCenterId(Converts.toLong(config.get("dataCenterId"), 1L));
        globalConfig.camelCaseToSnake(Converts.toBoolean(config.get("camelCaseToSnake"), true));
        globalConfig.debug(Converts.toBoolean(config.get("debug"), false));
        globalConfig.defaultPageLimit(Converts.toInteger(config.get("defaultPageLimit"), 10));
        globalConfig.queryTimeout(Converts.toInteger(config.get("queryTimeout"), 0));
        globalConfig.queryMaxRows(Converts.toInteger(config.get("queryMaxRows"), 0));
        globalConfig.maxFieldSize(Converts.toInteger(config.get("maxFieldSize"), 0));
        globalConfig.closeAfterExecuted(Converts.toBoolean(config.get("closeAfterExecuted"), false));
        LinkedList<DatabaseConfig> databaseConfigs = new LinkedList<DatabaseConfig>();
        Reflector reflector = new Reflector(DatabaseConfig.class);
        databaseConfigs.add(this.initDatabaseConfig(reflector, config));
        Object datasourcesObj = config.get("datasources");
        if (datasourcesObj != null) {
            List datasources = (List)datasourcesObj;
            for (Map datasource : datasources) {
                databaseConfigs.add(this.initDatabaseConfig(reflector, datasource));
            }
        }
        return databaseConfigs;
    }

    private DatabaseConfig initDatabaseConfig(Reflector reflector, Map<String, Object> config) {
        DatabaseConfig databaseConfig = (DatabaseConfig)reflector.newInstance();
        Iterator<FieldInvoker> fieldIterator = reflector.fieldIterator();
        while (fieldIterator.hasNext()) {
            FieldInvoker invoker = fieldIterator.next();
            String fieldName = invoker.getName();
            Object value = config.get(fieldName);
            if (value == null) continue;
            invoker.setValue(databaseConfig, Converts.to(invoker.getType(), value));
        }
        if (Utils.isEmpty(databaseConfig.getValidationQuery())) {
            databaseConfig.setTestWhileIdle(false);
        }
        return databaseConfig;
    }
}

