/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.config.parser;

import com.queryflow.common.QueryFlowException;
import com.queryflow.config.parser.AbstractConfigFileParser;
import com.queryflow.utils.Assert;
import com.queryflow.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;

public class PropertiesConfigFileParser
extends AbstractConfigFileParser<Map<String, Object>> {
    @Override
    public Map<String, Object> parse(String path) {
        Assert.notNull(path);
        try {
            return this.parse(this.parsePath(path));
        }
        catch (FileNotFoundException e) {
            throw new QueryFlowException("the config file not found", e);
        }
    }

    @Override
    public Map<String, Object> parse(File file) {
        try {
            FileReader fr = new FileReader(file);
            return this.parse(fr);
        }
        catch (FileNotFoundException e) {
            throw new QueryFlowException("the config file not exists", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> parse(InputStream in) {
        Object object;
        try {
            InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);
            object = this.parse(isr);
        }
        catch (Throwable throwable) {
            Utils.close(in);
            throw throwable;
        }
        Utils.close(in);
        return object;
    }

    @Override
    public Map<String, Object> parse(Reader reader) {
        Map<String, Object> map;
        Properties properties = new Properties();
        try {
            properties.load(reader);
            map = Utils.propertiesToMap(properties);
        }
        catch (IOException e) {
            try {
                throw new QueryFlowException("parser config file error", e);
            }
            catch (Throwable throwable) {
                Utils.close(reader);
                throw throwable;
            }
        }
        Utils.close(reader);
        return map;
    }
}

