/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.config.parser;

import com.queryflow.common.QueryFlowException;
import com.queryflow.config.parser.AbstractConfigFileParser;
import com.queryflow.utils.Assert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigFileParser
extends AbstractConfigFileParser<Map<String, Object>> {
    @Override
    public Map<String, Object> parse(String path) {
        Assert.notNull(path);
        try {
            return this.parse(this.parsePath(path));
        }
        catch (FileNotFoundException e) {
            throw new QueryFlowException("the config file not found", e);
        }
    }

    @Override
    public Map<String, Object> parse(File file) {
        try {
            FileReader fr = new FileReader(file);
            return this.parse(fr);
        }
        catch (FileNotFoundException e) {
            throw new QueryFlowException("the config file not exists", e);
        }
    }

    @Override
    public Map<String, Object> parse(InputStream in) {
        return this.parse(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    @Override
    public Map<String, Object> parse(Reader reader) {
        Yaml yaml = new Yaml();
        return (Map)yaml.load(reader);
    }
}

