/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.key;

import com.queryflow.common.QueryFlowException;
import com.queryflow.key.AutoIncrementKeyGenerator;
import com.queryflow.key.KeyGenerator;
import com.queryflow.key.SimpleKeyGenerator;
import com.queryflow.key.SnowflakeKeyGenerator;
import com.queryflow.key.UUIDKeyGenerator;
import com.queryflow.utils.Assert;
import com.queryflow.utils.Utils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public final class KeyGenerateUtil {
    private static final Map<Class<? extends KeyGenerator>, KeyGenerator> generators = new HashMap<Class<? extends KeyGenerator>, KeyGenerator>(2);

    private KeyGenerateUtil() {
    }

    public static void registerKeyGenerator(Class<? extends KeyGenerator> clazz) {
        Assert.notNull(clazz);
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("the key generator must not be interface or abstract class");
        }
        KeyGenerator keyGenerator = Utils.instantiate(clazz);
        generators.put(clazz, keyGenerator);
    }

    public static KeyGenerator getKeyGenerator(Class<? extends KeyGenerator> clazz) {
        return generators.get(clazz);
    }

    public static <T> T generateId(Class<? extends KeyGenerator<T>> clazz) {
        KeyGenerator keyGenerator = generators.get(clazz);
        if (keyGenerator == null) {
            throw new QueryFlowException("cannot found your key generator " + clazz.getName() + ", you must register it");
        }
        return keyGenerator.generate();
    }

    public static Long generateId() {
        return (Long)generators.get(SnowflakeKeyGenerator.class).generate();
    }

    public static int keyGeneratorSize() {
        return generators.size();
    }

    public static boolean containKeyGenerator(Class<? extends KeyGenerator> clazz) {
        return generators.containsKey(clazz);
    }

    static {
        KeyGenerateUtil.registerKeyGenerator(SnowflakeKeyGenerator.class);
        KeyGenerateUtil.registerKeyGenerator(AutoIncrementKeyGenerator.class);
        KeyGenerateUtil.registerKeyGenerator(UUIDKeyGenerator.class);
        KeyGenerateUtil.registerKeyGenerator(SimpleKeyGenerator.class);
    }
}

