/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.log;

import com.queryflow.log.Log;
import com.queryflow.log.LogException;
import com.queryflow.log.commons.JakartaCommonsLoggingImpl;
import com.queryflow.log.jdk14.Jdk14LoggingImpl;
import com.queryflow.log.log4j.Log4jImpl;
import com.queryflow.log.log4j2.Log4j2Impl;
import com.queryflow.log.nologging.NoLoggingImpl;
import com.queryflow.log.slf4j.Slf4jImpl;
import com.queryflow.log.stdout.StdOutImpl;
import java.lang.reflect.Constructor;

public final class LogFactory {
    public static final String MARKER = "SQLFLOW";
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> logger) {
        return LogFactory.getLog(logger.getName());
    }

    public static Log getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    public static synchronized void useCustomLogging(Class<? extends Log> clazz) {
        LogFactory.setImplementation(clazz);
    }

    public static synchronized void useSlf4jLogging() {
        LogFactory.setImplementation(Slf4jImpl.class);
    }

    public static synchronized void useCommonsLogging() {
        LogFactory.setImplementation(JakartaCommonsLoggingImpl.class);
    }

    public static synchronized void useLog4JLogging() {
        LogFactory.setImplementation(Log4jImpl.class);
    }

    public static synchronized void useLog4J2Logging() {
        LogFactory.setImplementation(Log4j2Impl.class);
    }

    public static synchronized void useJdkLogging() {
        LogFactory.setImplementation(Jdk14LoggingImpl.class);
    }

    public static synchronized void useStdOutLogging() {
        LogFactory.setImplementation(StdOutImpl.class);
    }

    public static synchronized void useNoLogging() {
        LogFactory.setImplementation(NoLoggingImpl.class);
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setImplementation(Class<? extends Log> implClass) {
        try {
            Constructor<? extends Log> candidate = implClass.getConstructor(String.class);
            Log log = candidate.newInstance(LogFactory.class.getName());
            if (log.isDebugEnabled()) {
                log.debug("Logging initialized using '" + implClass + "' adapter.");
            }
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useSlf4jLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useCommonsLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useLog4J2Logging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useLog4JLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useJdkLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useStdOutLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            @Override
            public void run() {
                LogFactory.useNoLogging();
            }
        });
    }
}

