/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.log.slf4j;

import com.queryflow.log.Log;
import com.queryflow.log.slf4j.Slf4jLocationAwareLoggerImpl;
import com.queryflow.log.slf4j.Slf4jLoggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jImpl
implements Log {
    private Log log;

    public Slf4jImpl(String clazz) {
        Logger logger = LoggerFactory.getLogger((String)clazz);
        if (logger instanceof LocationAwareLogger) {
            try {
                logger.getClass().getMethod("log", Marker.class, String.class, Integer.TYPE, String.class, Object[].class, Throwable.class);
                this.log = new Slf4jLocationAwareLoggerImpl((LocationAwareLogger)logger);
                return;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        this.log = new Slf4jLoggerImpl(logger);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.error(s, e);
    }

    @Override
    public void error(String s) {
        this.log.error(s);
    }

    @Override
    public void error(Throwable e) {
        this.log.error(e);
    }

    @Override
    public void debug(String s) {
        if (this.isDebugEnabled()) {
            this.log.debug(s);
        }
    }

    @Override
    public void debug(String s, Throwable e) {
        if (this.isDebugEnabled()) {
            this.log.debug(s, e);
        }
    }

    @Override
    public void trace(String s) {
        this.log.trace(s);
    }

    @Override
    public void warn(String s) {
        this.log.warn(s);
    }

    @Override
    public void info(String msg) {
        this.log.info(msg);
    }
}

