/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.log.slf4j;

import com.queryflow.log.Log;
import com.queryflow.log.slf4j.Slf4jImpl;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

class Slf4jLocationAwareLoggerImpl
implements Log {
    private static Marker MARKER = MarkerFactory.getMarker((String)"SQLFLOW");
    private static final String FQCN = Slf4jImpl.class.getName();
    private LocationAwareLogger logger;

    Slf4jLocationAwareLoggerImpl(LocationAwareLogger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        this.logger.log(MARKER, FQCN, 40, s, null, e);
    }

    @Override
    public void error(String s) {
        this.logger.log(MARKER, FQCN, 40, s, null, null);
    }

    @Override
    public void error(Throwable e) {
        this.logger.log(MARKER, FQCN, 40, "", null, e);
    }

    @Override
    public void debug(String s) {
        if (this.isDebugEnabled()) {
            this.logger.log(MARKER, FQCN, 10, s, null, null);
        }
    }

    @Override
    public void debug(String s, Throwable e) {
        if (this.isDebugEnabled()) {
            this.logger.log(MARKER, FQCN, 10, s, null, e);
        }
    }

    @Override
    public void trace(String s) {
        this.logger.log(MARKER, FQCN, 0, s, null, null);
    }

    @Override
    public void warn(String s) {
        this.logger.log(MARKER, FQCN, 30, s, null, null);
    }

    @Override
    public void info(String msg) {
        this.logger.log(MARKER, FQCN, 20, msg, null, null);
    }
}

