/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.mapper;

import com.queryflow.annotation.Mapper;
import com.queryflow.common.QueryFlowException;
import com.queryflow.mapper.proxy.CglibProxyFactory;
import com.queryflow.mapper.proxy.MapperMethodInterceptor;
import com.queryflow.mapper.proxy.ProxyFactory;
import com.queryflow.utils.Assert;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public final class MapperManager {
    private static final Map<Class<?>, Object> MAPPER_CLASS = new HashMap();
    private static final ProxyFactory PROXY_FACTORY = new CglibProxyFactory();

    private MapperManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object addMapperClass(Class<?> clazz, boolean registerToSpring, BeanFactory beanFactory) {
        Assert.notNull(clazz);
        if (clazz.getAnnotation(Mapper.class) == null) {
            throw new QueryFlowException(clazz.getName() + " not a mapper class");
        }
        Object proxy = MAPPER_CLASS.get(clazz);
        if (proxy == null) {
            Map<Class<?>, Object> map = MAPPER_CLASS;
            synchronized (map) {
                proxy = MAPPER_CLASS.get(clazz);
                if (proxy == null) {
                    proxy = PROXY_FACTORY.createProxy(clazz, (Callback)new MapperMethodInterceptor());
                    MAPPER_CLASS.put(clazz, proxy);
                }
            }
        }
        if (registerToSpring && beanFactory != null) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
            configurableBeanFactory.registerSingleton(clazz.getName(), proxy);
        }
        return proxy;
    }

    public static Object addMapperClass(Class<?> clazz) {
        return MapperManager.addMapperClass(clazz, false, null);
    }

    public static <T> T getMapperClass(Class<T> clazz) {
        Assert.notNull(clazz);
        Object obj = MAPPER_CLASS.get(clazz);
        if (obj == null) {
            throw new QueryFlowException(clazz.getName() + " not a mapper class");
        }
        return (T)obj;
    }
}

