/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.mapper;

import com.queryflow.mapper.SqlValue;
import com.queryflow.mapper.executor.ExecuteMethodExecutor;
import com.queryflow.mapper.executor.ListResultSelectMethodExecutor;
import com.queryflow.mapper.executor.MapperMethodExecutor;
import com.queryflow.mapper.executor.OneResultSelectMethodExecutor;
import java.util.LinkedList;
import java.util.List;

public class MapperMethod {
    private Class<?> returnClass;
    private ReturnType returnType;
    private String dataSourceTag;
    private String preparedSql;
    private MapperMethodExecutor executor;
    private SqlType sqlType;
    private List<SqlValue> sqlValues = new LinkedList<SqlValue>();

    public MapperMethod(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public void setPreparedSql(String preparedSql) {
        this.preparedSql = preparedSql;
    }

    public String getPreparedSql() {
        return this.preparedSql;
    }

    public void setReturnType(ReturnType returnType) {
        this.returnType = returnType;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public void setReturnClass(Class<?> returnClass) {
        this.returnClass = returnClass;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public void addSqlValue(SqlValue sqlValue) {
        this.sqlValues.add(sqlValue);
    }

    public List<SqlValue> getSqlValues() {
        return this.sqlValues;
    }

    public void setDataSourceTag(String dataSourceTag) {
        this.dataSourceTag = dataSourceTag;
    }

    public String getDataSourceTag() {
        return this.dataSourceTag;
    }

    public void buildExecutor() {
        if (this.sqlType == SqlType.EXECUTE) {
            this.executor = new ExecuteMethodExecutor(this.dataSourceTag, this.preparedSql, this.sqlValues);
        } else {
            switch (this.returnType) {
                case LIST_BEAN: 
                case LIST_MAP: {
                    this.executor = new ListResultSelectMethodExecutor(this.dataSourceTag, this.preparedSql, this.sqlValues, this.returnClass);
                    break;
                }
                case BEAN: 
                case MAP: {
                    this.executor = new OneResultSelectMethodExecutor(this.dataSourceTag, this.preparedSql, this.sqlValues, this.returnClass);
                }
            }
        }
    }

    public Object execute(Object target, Object[] args) {
        return this.executor.execute(target, args);
    }

    public static enum ReturnType {
        BEAN,
        MAP,
        LIST_BEAN,
        LIST_MAP;

    }

    public static enum SqlType {
        QUERY,
        EXECUTE;

    }
}

