/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.mapper;

import com.queryflow.annotation.Bind;
import com.queryflow.annotation.DataSource;
import com.queryflow.annotation.Select;
import com.queryflow.annotation.Update;
import com.queryflow.common.QueryFlowException;
import com.queryflow.mapper.MapperMethod;
import com.queryflow.mapper.MapperMethodParameter;
import com.queryflow.mapper.SqlValue;
import com.queryflow.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapperMethodBuilder {
    private static final Map<Method, MapperMethod> CONTAINER = new ConcurrentHashMap<Method, MapperMethod>();
    private static final String ERROR_RETURN_MESSAGE = "the return type of mapper methd supports List, Map, Jdbc Common class or bean object";
    private static final Pattern NAMED_PATTERN = Pattern.compile("(\\$\\{([^{}]+)\\})");
    private Method method;
    private String methodDesc;
    private MapperMethod.SqlType sqlType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MapperMethod getMapperMethod(Method method) {
        MapperMethod mapperMethod = CONTAINER.get(method);
        if (mapperMethod != null) return mapperMethod;
        Class<MapperMethodBuilder> clazz = MapperMethodBuilder.class;
        synchronized (MapperMethodBuilder.class) {
            mapperMethod = CONTAINER.get(method);
            if (mapperMethod != null) return mapperMethod;
            return new MapperMethodBuilder(method).build();
        }
    }

    public MapperMethodBuilder(Method method) {
        this.method = method;
        Class<?> declaringClass = method.getDeclaringClass();
        this.methodDesc = declaringClass.getName() + " " + method.getName();
    }

    public MapperMethod build() {
        MapperMethod mapperMethod = CONTAINER.get(this.method);
        if (mapperMethod != null) {
            return mapperMethod;
        }
        if (Modifier.isAbstract(this.method.getModifiers())) {
            String rawSql;
            Select select = this.method.getAnnotation(Select.class);
            Update update = this.method.getAnnotation(Update.class);
            if (select != null) {
                this.sqlType = MapperMethod.SqlType.QUERY;
                mapperMethod = new MapperMethod(MapperMethod.SqlType.QUERY);
                rawSql = select.value();
            } else if (update != null) {
                this.sqlType = MapperMethod.SqlType.EXECUTE;
                mapperMethod = new MapperMethod(MapperMethod.SqlType.EXECUTE);
                rawSql = update.value();
            } else {
                throw new QueryFlowException(this.methodDesc, "the method is abstract, but is not a mapper method");
            }
            if (Utils.isBlank(rawSql)) {
                throw new QueryFlowException(this.methodDesc, "you must specify a sql for the mapper method");
            }
            DataSource dataSource = this.method.getAnnotation(DataSource.class);
            if (dataSource != null) {
                mapperMethod.setDataSourceTag(dataSource.value());
            }
            List<String> names = this.parseSql(rawSql, mapperMethod);
            Map<String, MapperMethodParameter> parameterMap = this.parseParameter();
            this.paramterToSqlName(names, parameterMap, mapperMethod);
            this.parseReturnType(mapperMethod);
            mapperMethod.buildExecutor();
            CONTAINER.put(this.method, mapperMethod);
        }
        return mapperMethod;
    }

    private List<String> parseSql(String rawSql, MapperMethod mapperMethod) {
        StringBuffer result = new StringBuffer(rawSql.length());
        Matcher matcher = NAMED_PATTERN.matcher(rawSql);
        ArrayList<String> names = new ArrayList<String>();
        while (matcher.find()) {
            String name = matcher.group(2);
            if (Utils.isEmpty(name)) {
                throw new QueryFlowException(this.methodDesc, "you muse specify a name in the sql interpolations");
            }
            names.add(name);
            matcher.appendReplacement(result, "?");
        }
        matcher.appendTail(result);
        mapperMethod.setPreparedSql(result.toString());
        return names;
    }

    private Map<String, MapperMethodParameter> parseParameter() {
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        HashMap<String, MapperMethodParameter> parameterMap = new HashMap<String, MapperMethodParameter>();
        Type[] parameterTypes = this.method.getGenericParameterTypes();
        if (parameterTypes != null && parameterTypes.length > 0) {
            int len = parameterTypes.length;
            block0: for (int i = 0; i < len; ++i) {
                Type parameterType = parameterTypes[i];
                Annotation[] paramterAnnos = parameterAnnotations[i];
                if (paramterAnnos == null || paramterAnnos.length <= 0) continue;
                for (Annotation anno : paramterAnnos) {
                    if (!anno.annotationType().equals(Bind.class)) continue;
                    Bind bind = (Bind)anno;
                    MapperMethodParameter parameter = new MapperMethodParameter(bind.value(), parameterType, i);
                    parameterMap.put(bind.value(), parameter);
                    continue block0;
                }
            }
        }
        return parameterMap;
    }

    private void paramterToSqlName(List<String> names, Map<String, MapperMethodParameter> parameters, MapperMethod mapperMethod) {
        if (names.isEmpty()) {
            return;
        }
        if (parameters.isEmpty()) {
            throw new QueryFlowException(this.methodDesc, "you must specify mapper mathod parameters");
        }
        String childName = "";
        int len = names.size();
        for (int i = 0; i < len; ++i) {
            MapperMethodParameter parameter;
            String name = names.get(i);
            if (name.contains(".")) {
                String[] splitNames = name.split("\\.");
                if (splitNames.length == 1 || splitNames.length > 2) {
                    throw new QueryFlowException(this.methodDesc, "only one dot is allowed in the sql placeholder");
                }
                parameter = parameters.get(splitNames[0]);
                childName = splitNames[1];
            } else {
                parameter = parameters.get(name);
            }
            if (parameter == null) {
                throw new QueryFlowException(this.methodDesc, "cound found the method paramter by the name: " + name);
            }
            SqlValue sqlValue = new SqlValue();
            switch (parameter.getParameterType()) {
                case MAP: {
                    sqlValue.setType(SqlValue.Type.MAP_VALUE);
                    sqlValue.setName(childName);
                    break;
                }
                case BEAN: {
                    sqlValue.setType(SqlValue.Type.BEAN_VALUE);
                    sqlValue.setName(childName);
                    sqlValue.setBeanClass((Class)parameter.getType());
                    break;
                }
                case COMMON: {
                    sqlValue.setType(SqlValue.Type.VALUE);
                    sqlValue.setName(name);
                }
            }
            sqlValue.setIndex(parameter.getIndex());
            mapperMethod.addSqlValue(sqlValue);
        }
    }

    private void parseReturnType(MapperMethod mapperMethod) {
        if (this.sqlType == MapperMethod.SqlType.EXECUTE) {
            return;
        }
        Type genericReturnType = this.method.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            if (List.class.equals((Object)genericReturnType)) {
                throw new QueryFlowException("");
            }
            if (Map.class.equals((Object)genericReturnType)) {
                mapperMethod.setReturnType(MapperMethod.ReturnType.MAP);
            } else {
                mapperMethod.setReturnType(MapperMethod.ReturnType.BEAN);
            }
            mapperMethod.setReturnClass((Class)genericReturnType);
        } else if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (List.class.equals((Object)rawType)) {
                Type actualType = parameterizedType.getActualTypeArguments()[0];
                if (actualType instanceof Class) {
                    Class actualClass = (Class)actualType;
                    if (List.class.isAssignableFrom(actualClass)) {
                        throw new QueryFlowException(this.methodDesc, "the mapper method returns a List, but the generics of list not support List");
                    }
                    if (Map.class.equals((Object)actualClass)) {
                        mapperMethod.setReturnType(MapperMethod.ReturnType.LIST_MAP);
                    } else {
                        mapperMethod.setReturnType(MapperMethod.ReturnType.LIST_BEAN);
                    }
                    mapperMethod.setReturnClass(actualClass);
                } else if (actualType instanceof ParameterizedType) {
                    ParameterizedType secondParameterizedTye = (ParameterizedType)actualType;
                    if (!Map.class.equals((Object)secondParameterizedTye.getOwnerType())) {
                        throw new QueryFlowException(this.methodDesc, ERROR_RETURN_MESSAGE);
                    }
                    mapperMethod.setReturnClass(Map.class);
                    mapperMethod.setReturnType(MapperMethod.ReturnType.LIST_MAP);
                }
            } else if (Map.class.equals((Object)rawType)) {
                mapperMethod.setReturnType(MapperMethod.ReturnType.MAP);
                mapperMethod.setReturnClass(Map.class);
            } else {
                throw new QueryFlowException(this.methodDesc, ERROR_RETURN_MESSAGE);
            }
        }
    }
}

