/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.mapper;

import com.queryflow.common.QueryFlowException;
import com.queryflow.utils.JdbcUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class MapperMethodParameter {
    private String name;
    private Type genericType;
    private int index;
    private ParameterType parameterType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapperMethodParameter(String name, Type genericType, int index) {
        this.name = name;
        this.index = index;
        this.genericType = genericType;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type rawType = parameterizedType.getRawType();
            if (!Map.class.isAssignableFrom((Class)rawType)) throw new QueryFlowException("the mapper method parameters must be the jdbc common type or the map type");
            this.parameterType = ParameterType.MAP;
            return;
        } else {
            if (!(genericType instanceof Class)) return;
            if (Map.class.isAssignableFrom((Class)genericType)) {
                this.parameterType = ParameterType.MAP;
                return;
            } else {
                if (List.class.isAssignableFrom((Class)genericType)) {
                    throw new QueryFlowException("not support List type in the mapper method parameters");
                }
                this.parameterType = JdbcUtil.isJdbcCommonClass(genericType) ? ParameterType.COMMON : ParameterType.BEAN;
            }
        }
    }

    public Type getType() {
        return this.genericType;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public static enum ParameterType {
        MAP,
        BEAN,
        COMMON;

    }
}

