/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.mapper.executor;

import com.queryflow.accessor.Accessor;
import com.queryflow.accessor.AccessorFactory;
import com.queryflow.common.QueryFlowException;
import com.queryflow.mapper.SqlValue;
import com.queryflow.reflection.ReflectionUtil;
import com.queryflow.reflection.Reflector;
import com.queryflow.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class MapperMethodExecutor {
    protected List<SqlValue> sqlValues;
    protected String sql;
    protected String dataSourceTag;

    public MapperMethodExecutor(String dataSourceTag, String sql, List<SqlValue> sqlValues) {
        this.dataSourceTag = dataSourceTag;
        this.sql = sql;
        if (sqlValues == null) {
            sqlValues = Collections.emptyList();
        }
        this.sqlValues = sqlValues;
    }

    public abstract Object execute(Object var1, Object[] var2);

    protected Accessor getAccessor() {
        Accessor accessor = Utils.isEmpty(this.dataSourceTag) ? AccessorFactory.accessor() : AccessorFactory.accessor(this.dataSourceTag);
        if (accessor == null) {
            throw new QueryFlowException("cannot found the accessor by datasource tag:" + this.dataSourceTag);
        }
        return accessor;
    }

    protected Object[] fillValues(Object[] args) {
        Object[] values = new Object[this.sqlValues.size()];
        int size = this.sqlValues.size();
        block5: for (int i = 0; i < size; ++i) {
            SqlValue sqlValue = this.sqlValues.get(i);
            int index = sqlValue.getIndex();
            switch (sqlValue.getType()) {
                case VALUE: {
                    values[i] = args[index];
                    continue block5;
                }
                case MAP_VALUE: {
                    values[i] = ((Map)args[index]).get(sqlValue.getName());
                    continue block5;
                }
                case BEAN_VALUE: {
                    Object reflector = ReflectionUtil.forEntityClass(sqlValue.getBeanClass());
                    values[i] = ((Reflector)reflector).getFieldValue(sqlValue.getName(), args[index]);
                }
            }
        }
        return values;
    }
}

