/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.page;

import java.io.Serializable;
import java.util.List;

public class Pager<T>
implements Serializable {
    private List<T> records;
    private int total;
    private int page;
    private int limit;
    private int start;
    private int pages;

    public Pager(int total, int page, List<T> records) {
        this(total, page, 0, records);
    }

    public Pager(int total, int page, int limit, List<T> records) {
        this.records = records;
        this.init(total, page, limit);
    }

    private void init(int total, int page, int limit) {
        this.total = total;
        this.limit = limit;
        int n = this.pages = total % limit == 0 ? total / limit : total / limit + 1;
        if (page <= 0) {
            page = 1;
        } else if (page > this.pages) {
            page = this.pages;
        }
        this.page = page;
        this.start = (page - 1) * limit;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public String toString() {
        return "Pager{records=" + this.records + ", total=" + this.total + ", page=" + this.page + ", limit=" + this.limit + ", start=" + this.start + ", pages=" + this.pages + '}';
    }
}

