/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.page;

import com.queryflow.common.DbType;
import com.queryflow.page.DerbyPageSqlMatchProcess;
import com.queryflow.page.H2PageSqlMatchProcess;
import com.queryflow.page.MysqlPageSqlMatchProcess;
import com.queryflow.page.OraclePageSqlMatchProcess;
import com.queryflow.page.PageSqlMatchProcess;
import com.queryflow.page.PageSqlProcessSelector;
import com.queryflow.page.SQLitePageSqlMatchProcess;
import com.queryflow.page.SqlServerPageSqlMatchProcess;
import com.queryflow.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public final class SimplePageSqlProcessSelector
implements PageSqlProcessSelector {
    private Map<String, PageSqlMatchProcess> processes = new HashMap<String, PageSqlMatchProcess>();
    private Map<String, Class<? extends PageSqlMatchProcess>> processClasses = new HashMap<String, Class<? extends PageSqlMatchProcess>>();

    public SimplePageSqlProcessSelector() {
        this.processClasses.put(DbType.DERBY.value(), DerbyPageSqlMatchProcess.class);
        this.processClasses.put(DbType.H2.value(), H2PageSqlMatchProcess.class);
        this.processClasses.put(DbType.MYSQL.value(), MysqlPageSqlMatchProcess.class);
        this.processClasses.put(DbType.ORACLE.value(), OraclePageSqlMatchProcess.class);
        this.processClasses.put(DbType.SQLITE.value(), SQLitePageSqlMatchProcess.class);
        this.processClasses.put(DbType.SQLSERVER.value(), SqlServerPageSqlMatchProcess.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageSqlMatchProcess select(String dbType) {
        PageSqlMatchProcess process = this.processes.get(dbType);
        if (process == null) {
            SimplePageSqlProcessSelector simplePageSqlProcessSelector = this;
            synchronized (simplePageSqlProcessSelector) {
                process = this.processes.get(dbType);
                if (process == null) {
                    Class<? extends PageSqlMatchProcess> processClass = this.processClasses.get(dbType);
                    if (processClass == null) {
                        throw new RuntimeException(String.format("\u6839\u636e\u6570\u636e\u5e93\u7c7b\u578b:%s,\u83b7\u53d6\u4e0d\u5230\u76f8\u5e94\u7684PageSqlMatchProcess\u5206\u9875\u5904\u7406\u5668", dbType));
                    }
                    process = Utils.instantiate(processClass);
                    this.processes.put(dbType, process);
                }
            }
        }
        return process;
    }

    public static void main(String[] args) {
        SimplePageSqlProcessSelector selector = new SimplePageSqlProcessSelector();
        selector.select(DbType.MYSQL.value());
    }
}

