/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.reflection;

import com.queryflow.cache.Cache;
import com.queryflow.cache.impl.LRUCache;
import com.queryflow.reflection.Reflector;
import com.queryflow.reflection.entity.EntityReflector;

public class ReflectionUtil {
    private static final Cache<Class<?>, Reflector> CACHE = new LRUCache();

    private ReflectionUtil() {
    }

    public static Reflector forClass(Class clazz) {
        Reflector reflector = CACHE.getValue(clazz);
        if (reflector == null) {
            reflector = new Reflector(clazz);
            CACHE.putValue(clazz, reflector);
        }
        return reflector;
    }

    public static <T extends EntityReflector> T forEntityClass(Class<?> clazz) {
        Reflector reflector = CACHE.getValue(clazz);
        if (reflector == null) {
            reflector = new EntityReflector(clazz);
            CACHE.putValue(clazz, reflector);
        }
        return (T)((EntityReflector)reflector);
    }
}

