/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.reflection;

import com.queryflow.reflection.ReflectionException;
import com.queryflow.reflection.invoker.FieldInvoker;
import com.queryflow.reflection.invoker.MethodInvoker;
import com.queryflow.reflection.invoker.NormalMethod;
import com.queryflow.reflection.invoker.Property;
import com.queryflow.utils.Assert;
import com.queryflow.utils.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Reflector {
    protected Class<?> type;
    protected Constructor defaultConstructor;
    protected Map<String, FieldInvoker> fieldInvokers;
    protected Map<String, MethodInvoker> methodInvokers;
    protected boolean skipFinalField;

    public Reflector(Class<?> clazz) {
        this(clazz, true);
    }

    public Reflector(Class<?> clazz, boolean skipFinalField) {
        Assert.notNull(clazz);
        this.type = clazz;
        this.defaultConstructor();
        this.initFieldInvokers();
        this.initMethodInvokers();
        this.skipFinalField = skipFinalField;
    }

    private void defaultConstructor() {
        this.defaultConstructor = Utils.getDefaultConstructor(this.type);
    }

    protected void initFieldInvokers() {
        Field[] fields = this.type.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            this.fieldInvokers = new HashMap<String, FieldInvoker>(fields.length);
            for (Field field : fields) {
                if (this.skipFinalField || Modifier.isFinal(field.getModifiers())) continue;
                this.fieldInvokers.put(field.getName(), this.createFieldInvoker(field));
            }
        } else {
            this.fieldInvokers = Collections.emptyMap();
        }
    }

    protected void initMethodInvokers() {
        Method[] methods = this.type.getDeclaredMethods();
        if (methods != null && methods.length > 0) {
            this.methodInvokers = new HashMap<String, MethodInvoker>(methods.length);
            for (Method method : methods) {
                this.methodInvokers.put(method.getName(), this.createMethodInvoker(method));
            }
        } else {
            this.methodInvokers = Collections.emptyMap();
        }
    }

    protected FieldInvoker createFieldInvoker(Field field) {
        return new Property(field);
    }

    protected MethodInvoker createMethodInvoker(Method method) {
        return new NormalMethod(method);
    }

    public void setFieldValue(String fieldName, Object target, Object value) {
        FieldInvoker fieldInvoker = this.fieldInvokers.get(fieldName);
        if (fieldInvoker == null) {
            throw new ReflectionException("no such field " + fieldName + " in " + this.type.getName());
        }
        fieldInvoker.setValue(target, value);
    }

    public Object getFieldValue(String fieldName, Object target) {
        FieldInvoker fieldInvoker = this.fieldInvokers.get(fieldName);
        if (fieldInvoker == null) {
            throw new ReflectionException("no such field " + fieldName + " in " + this.type.getName() + ", or the field is final");
        }
        return fieldInvoker.getValue(target);
    }

    public Object invokeMethod(String methodName, Object target, Object ... args) {
        MethodInvoker methodInvoker = this.methodInvokers.get(methodName);
        if (methodInvoker == null) {
            throw new ReflectionException("no such method " + methodName + " in " + this.type.getName());
        }
        return methodInvoker.invoke(target, args);
    }

    public Object newInstance() {
        try {
            return this.defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public FieldInvoker getFieldInvoker(String fieldName) {
        return this.fieldInvokers.get(fieldName);
    }

    public MethodInvoker getMethodInvoker(String methodName) {
        return this.methodInvokers.get(methodName);
    }

    public Iterator<FieldInvoker> fieldIterator() {
        return this.fieldInvokers.values().iterator();
    }

    public Iterator<MethodInvoker> methodIterator() {
        return this.methodInvokers.values().iterator();
    }

    public int fieldSize() {
        return this.fieldInvokers.size();
    }

    public int methodSize() {
        return this.methodInvokers.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.getName());
        sb.append("{fields: ").append(this.fieldInvokers.values()).append("; methods: ").append(this.methodInvokers.values()).append("}");
        return sb.toString();
    }
}

