/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.reflection.entity;

import com.queryflow.annotation.Column;
import com.queryflow.annotation.Id;
import com.queryflow.common.DictionaryEnum;
import com.queryflow.key.KeyGenerator;
import com.queryflow.reflection.invoker.Property;
import com.queryflow.utils.Utils;
import java.lang.reflect.Field;

public class EntityField
extends Property {
    private boolean exists = true;
    private boolean isIdField = false;
    private Class<? extends KeyGenerator> keyGeneratorClass;
    private String columnName;
    private boolean isDictionaryKey = false;
    private Class<? extends DictionaryEnum> dicClass;

    public EntityField(Field field) {
        this(field, false);
    }

    public EntityField(Field field, boolean camelCaseToSnake) {
        super(field);
        this.init();
        if (Utils.isBlank(this.columnName)) {
            this.columnName = field.getName();
            if (camelCaseToSnake) {
                this.columnName = Utils.camelCaseToSnake(this.columnName);
            }
        }
    }

    private void init() {
        Id id = this.field.getAnnotation(Id.class);
        if (id != null) {
            this.isIdField = true;
            this.columnName = id.value();
            this.keyGeneratorClass = id.keyGenerator();
            return;
        }
        Column column = this.field.getAnnotation(Column.class);
        if (column != null) {
            this.isIdField = false;
            this.columnName = column.value();
            this.exists = column.exists();
            this.isDictionaryKey = column.isDictionaryKey();
            if (this.isDictionaryKey) {
                this.dicClass = column.dictionaryClass();
                if (this.dicClass == DictionaryEnum.class && DictionaryEnum.class.isAssignableFrom(this.getType())) {
                    this.dicClass = this.getType();
                }
            }
            return;
        }
        this.isIdField = false;
        this.exists = true;
        this.isDictionaryKey = false;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isIdField() {
        return this.isIdField;
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    public <T> Class<? extends KeyGenerator<T>> getKeyGeneratorClass() {
        return this.keyGeneratorClass;
    }

    public String getColumnName() {
        return this.getName();
    }

    public boolean isDictionaryKey() {
        return this.isDictionaryKey;
    }

    public Class<? extends DictionaryEnum> getDicClass() {
        return this.dicClass;
    }

    public boolean isZeroValue(Object target) {
        Class<?> clazz = this.getType();
        Object value = this.getValue(target);
        if (Boolean.TYPE == clazz) {
            return Boolean.FALSE.equals(value);
        }
        if (clazz.isPrimitive()) {
            Number num = (Number)value;
            return num.doubleValue() == 0.0;
        }
        return value == null;
    }

    @Override
    public void setValue(Object target, Object value) {
        if (this.isDictionaryKey()) {
            if (this.getType() == String.class) {
                DictionaryEnum[] constants;
                for (DictionaryEnum constant : constants = this.dicClass.getEnumConstants()) {
                    if (!constant.getCode().equals(value)) continue;
                    super.setValue(target, constant.getValue());
                    break;
                }
            } else if (DictionaryEnum.class.isAssignableFrom(this.getType())) {
                DictionaryEnum[] constants;
                for (DictionaryEnum constant : constants = this.dicClass.getEnumConstants()) {
                    if (!constant.getCode().equals(value)) continue;
                    super.setValue(target, constant);
                    break;
                }
            }
        } else {
            super.setValue(target, value);
        }
    }

    @Override
    public Object getValue(Object target) {
        Object value = super.getValue(target);
        if (this.isDictionaryKey()) {
            if (this.getType() == String.class) {
                DictionaryEnum[] constants;
                for (DictionaryEnum constant : constants = this.dicClass.getEnumConstants()) {
                    if (!constant.getValue().equals(value)) continue;
                    return constant.getCode();
                }
            } else if (DictionaryEnum.class.isAssignableFrom(this.getType())) {
                return ((DictionaryEnum)value).getCode();
            }
        }
        return value;
    }
}

