/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.reflection.entity;

import com.queryflow.annotation.Table;
import com.queryflow.config.GlobalConfig;
import com.queryflow.reflection.FieldReflector;
import com.queryflow.reflection.entity.EntityField;
import com.queryflow.reflection.invoker.FieldInvoker;
import com.queryflow.utils.Utils;
import java.lang.reflect.Field;
import java.util.Locale;

public class EntityReflector
extends FieldReflector {
    private String tableName;
    private boolean isNormalBean = false;
    private EntityField idField;

    public EntityReflector(Class<?> clazz) {
        this(clazz, true);
    }

    public EntityReflector(Class<?> clazz, boolean skipFinalField) {
        super(clazz, skipFinalField);
        this.parseTableName(clazz);
    }

    @Override
    protected FieldInvoker createFieldInvoker(Field field) {
        if (this.isNormalBean) {
            return super.createFieldInvoker(field);
        }
        EntityField entityField = new EntityField(field, GlobalConfig.isCamelCaseToSnake());
        if (entityField.isIdField()) {
            this.idField = entityField;
        }
        return entityField;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isNormalBean() {
        return this.isNormalBean;
    }

    public EntityField getField(String name) {
        return this.fieldInvokers == null ? null : (EntityField)this.fieldInvokers.get(name);
    }

    public EntityField getIdField() {
        return this.idField;
    }

    private void parseTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table != null) {
            this.isNormalBean = false;
            this.tableName = table.value();
            if (Utils.isBlank(this.tableName)) {
                this.tableName = this.formatTableName(clazz.getSimpleName());
            }
        } else {
            this.isNormalBean = true;
        }
    }

    private String formatTableName(String tableName) {
        int length = tableName.length();
        if (length == 1) {
            return tableName.toLowerCase(Locale.ENGLISH);
        }
        return tableName.substring(0, 1).toLowerCase(Locale.ENGLISH) + tableName.substring(1);
    }
}

