/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.reflection.invoker;

import com.queryflow.reflection.ReflectionException;
import com.queryflow.reflection.invoker.MethodInvoker;
import com.queryflow.utils.Assert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class NormalMethod
implements MethodInvoker {
    private Method method;

    public NormalMethod(Method method) {
        Assert.notNull(method);
        this.method = method;
        this.method.setAccessible(true);
    }

    @Override
    public Object invoke(Object target, Object ... args) {
        try {
            return this.method.invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public boolean isHide() {
        return !Modifier.isPublic(this.method.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.method.getModifiers());
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isAbstract()) {
            sb.append("abstract ");
        }
        sb.append(this.method.getReturnType().getName()).append(" ").append(this.method.getName()).append("(");
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int len = parameterTypes.length;
        for (int i = 0; i < len; ++i) {
            sb.append(parameterTypes[i].getName());
            if (i >= len - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

