/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.reflection.invoker;

import com.queryflow.reflection.ReflectionException;
import com.queryflow.reflection.invoker.FieldInvoker;
import com.queryflow.reflection.invoker.MethodInvoker;
import com.queryflow.reflection.invoker.NormalMethod;
import com.queryflow.utils.Assert;
import com.queryflow.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Property
implements FieldInvoker {
    protected Field field;
    private MethodInvoker setter;
    private MethodInvoker getter;

    public Property(Field field) {
        Assert.notNull(field);
        this.init(field);
    }

    public Property(String propertyName, Class<?> clazz) {
        Assert.notNull(propertyName);
        Assert.notNull(clazz);
        Field field = this.getField(propertyName, clazz);
        if (field == null) {
            throw new ReflectionException("no such field " + propertyName + " in " + clazz.getName());
        }
        this.init(field);
    }

    private void init(Field field) {
        Method getterMethod;
        this.field = field;
        Method setterMethod = Utils.setterMethod(field);
        if (setterMethod != null) {
            this.setter = new NormalMethod(setterMethod);
        }
        if ((getterMethod = Utils.getterMethod(field)) != null) {
            this.getter = new NormalMethod(getterMethod);
        }
        if (setterMethod == null || getterMethod == null) {
            try {
                this.field.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getValue(Object target) {
        if (this.getter != null) {
            return this.getter.invoke(target, new Object[0]);
        }
        try {
            return this.field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public void setValue(Object target, Object value) {
        if (this.setter != null) {
            this.setter.invoke(target, value);
        } else {
            try {
                this.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
        }
    }

    public Annotation getAnnotation(Class<? extends Annotation> clazz) {
        return this.field.getAnnotation(clazz);
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public boolean isHide() {
        return !Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public boolean readable() {
        return this.field.isAccessible() || this.getter != null;
    }

    @Override
    public boolean writeable() {
        return !this.isFinal() && (this.field.isAccessible() || this.setter != null);
    }

    private Field getField(String fieldName, Class<?> clazz) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.field.getName());
        sb.append("{");
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isFinal()) {
            sb.append("final ");
        }
        sb.append("type=").append(this.field.getType().getName()).append(", ").append("setter=").append(this.setter).append(", getter=").append(this.getter).append("}");
        return sb.toString();
    }
}

