/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.sql;

import com.queryflow.accessor.Accessor;
import com.queryflow.accessor.AccessorFactory;
import com.queryflow.common.QueryFlowException;
import com.queryflow.utils.Utils;
import java.util.LinkedList;
import java.util.List;

public class Insert {
    private String table;
    private StringBuilder columns;
    private List<Object> values;
    private StringBuilder marks;

    public Insert(String table) {
        this.table = table;
        this.columns = new StringBuilder();
        this.values = new LinkedList<Object>();
        this.marks = new StringBuilder();
    }

    public Insert column(String column, Object value) {
        this.columns.append(column).append(',');
        this.values.add(value);
        this.marks.append("?,");
        return this;
    }

    public Insert columns(String ... columns) {
        if (columns != null && columns.length > 0) {
            for (String column : columns) {
                this.columns.append(column).append(',');
            }
        }
        return this;
    }

    public Insert values(Object ... values) {
        if (values != null && values.length > 0) {
            for (Object value : values) {
                this.values.add(value);
                this.marks.append("?,");
            }
        }
        return this;
    }

    public String buildSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO ").append(this.table);
        if (this.columns.length() > 0) {
            sql.append(" (").append(this.columns.substring(0, this.columns.length() - 1)).append(")");
        }
        if (this.values.isEmpty()) {
            throw new QueryFlowException("Undefined value to insert");
        }
        sql.append(" VALUES (").append(this.marks.substring(0, this.marks.length() - 1)).append(")");
        return sql.toString();
    }

    public List<Object> getValues() {
        return this.values;
    }

    public int execute() {
        Accessor accessor = AccessorFactory.accessor();
        return accessor.update(this.buildSql(), Utils.toArray(this.values));
    }

    public int execute(String dataSourceTag) {
        Accessor accessor = AccessorFactory.accessor(dataSourceTag);
        return accessor.update(this.buildSql(), Utils.toArray(this.values));
    }
}

