/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.sql;

import com.queryflow.accessor.Accessor;
import com.queryflow.accessor.AccessorFactory;
import com.queryflow.sql.OrderType;
import com.queryflow.sql.Where;
import com.queryflow.utils.Utils;
import java.util.List;

public class Select
extends Where<Select> {
    private StringBuilder orderBy = new StringBuilder();
    private StringBuilder groupBy = new StringBuilder();
    private String havingCondition;

    public Select(String ... columns) {
        if (columns == null || columns.length == 0) {
            this.appender.append("SELECT *");
        } else {
            this.appender.append("SELECT ");
            int len = columns.length;
            for (int i = 0; i < len; ++i) {
                String column = columns[i];
                this.appender.append(column);
                if (i >= len - 1) continue;
                this.appender.append(", ");
            }
        }
    }

    public Select from(String tables) {
        this.appender.append(" FROM ").append(tables);
        return this;
    }

    public Select groupBy(String column) {
        this.groupBy.append(column).append(",");
        return this;
    }

    public Select groupBy(String ... columns) {
        if (columns != null && columns.length > 0) {
            for (String column : columns) {
                this.groupBy.append(column).append(",");
            }
        }
        return this;
    }

    public Select having(String condition) {
        if (Utils.isNotEmpty(condition)) {
            this.havingCondition = condition;
        }
        return this;
    }

    public Select having(String condition, Object value) {
        if (Utils.isNotEmpty(condition)) {
            this.havingCondition = condition;
            this.values.add(value);
        }
        return this;
    }

    public Select orderBy(String column) {
        return this.orderBy(column, null);
    }

    public Select orderBy(String column, OrderType orderType) {
        if (orderType == null) {
            orderType = OrderType.DESC;
        }
        this.orderBy.append(column).append(' ').append(orderType.name()).append(",");
        return this;
    }

    public Select orderByDesc(String column) {
        this.orderBy.append(column).append(" DESC,");
        return this;
    }

    public Select orderByAcs(String column) {
        this.orderBy.append(column).append(" ACS,");
        return this;
    }

    public String buildSql() {
        StringBuilder sql = new StringBuilder(this.appender);
        if (this.hasWhere) {
            sql.append(")");
        }
        if (this.groupBy.length() > 0) {
            sql.append(" GROUP BY ").append(this.groupBy.substring(0, this.groupBy.length() - 1));
            if (Utils.isNotEmpty(this.havingCondition)) {
                sql.append(" HAVING ").append(this.havingCondition);
            }
        }
        if (this.orderBy.length() > 0) {
            sql.append(" ORDER BY ").append(this.orderBy.substring(0, this.orderBy.length() - 1));
        }
        return sql.toString();
    }

    public <T> T query(Class<T> requiredType) {
        Accessor accessor = AccessorFactory.accessor();
        return accessor.query(this.buildSql(), this.values).one(requiredType);
    }

    public <T> T query(String dataSourceTag, Class<T> requiredType) {
        Accessor accessor = AccessorFactory.accessor(dataSourceTag);
        return accessor.query(this.buildSql(), this.values).one(requiredType);
    }

    public <T> List<T> queryList(Class<T> requiredType) {
        Accessor accessor = AccessorFactory.accessor();
        return accessor.query(this.buildSql(), this.values).list(requiredType);
    }

    public <T> List<T> queryList(String dataSourceTag, Class<T> requiredType) {
        Accessor accessor = AccessorFactory.accessor(dataSourceTag);
        return accessor.query(this.buildSql(), this.values).list(requiredType);
    }
}

