/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.sql;

import com.queryflow.common.QueryFlowException;
import com.queryflow.key.KeyGenerateUtil;
import com.queryflow.reflection.ReflectionUtil;
import com.queryflow.reflection.Reflector;
import com.queryflow.reflection.entity.EntityField;
import com.queryflow.reflection.entity.EntityReflector;
import com.queryflow.reflection.invoker.FieldInvoker;
import com.queryflow.sql.Delete;
import com.queryflow.sql.Insert;
import com.queryflow.sql.Select;
import com.queryflow.sql.Update;
import com.queryflow.utils.Assert;
import java.io.Serializable;
import java.util.Iterator;

public final class SqlBox {
    private SqlBox() {
    }

    public static int insert(Object entity) {
        return SqlBox.insert(entity, "");
    }

    public static int insert(Object entity, String dataSourceTag) {
        if (entity != null) {
            Object reflector = ReflectionUtil.forEntityClass(entity.getClass());
            if (((EntityReflector)reflector).isNormalBean()) {
                throw new QueryFlowException("the bean is not a table entity: " + entity.getClass().getName());
            }
            Iterator<FieldInvoker> iterator = ((Reflector)reflector).fieldIterator();
            Insert insert = new Insert(((EntityReflector)reflector).getTableName());
            while (iterator.hasNext()) {
                Object value;
                EntityField field = (EntityField)iterator.next();
                if (field.isIdField()) {
                    value = field.getValue(entity);
                    if (field.isZeroValue(entity)) {
                        value = KeyGenerateUtil.generateId(field.getKeyGeneratorClass());
                    }
                    if (value == null) continue;
                    insert.column(field.getColumnName(), value);
                    continue;
                }
                if (!field.exists()) continue;
                value = field.getValue(entity);
                insert.column(field.getColumnName(), value);
            }
            return insert.execute(dataSourceTag);
        }
        return 0;
    }

    public static Insert insert(String table) {
        return new Insert(table);
    }

    public static Update update(String table) {
        return new Update(table);
    }

    public static Delete delete(String table) {
        return new Delete(table);
    }

    public static int deleteById(String table, String idColumn, Serializable id) {
        return SqlBox.deleteById(table, idColumn, id, "");
    }

    public static int deleteById(String table, String idColumn, Serializable id, String dataSourceTag) {
        return ((Delete)((Delete)new Delete(table).where()).eq(idColumn, id)).execute(dataSourceTag);
    }

    public static int deleteById(Class<?> entityClass, Serializable id) {
        return SqlBox.deleteById(entityClass, id, "");
    }

    public static int deleteById(Class<?> entityClass, Serializable id, String dataSourceTag) {
        Assert.notNull(entityClass);
        Object reflector = ReflectionUtil.forEntityClass(entityClass);
        if (((EntityReflector)reflector).isNormalBean()) {
            throw new QueryFlowException("the class is not a table entity: " + entityClass.getName());
        }
        String table = ((EntityReflector)reflector).getTableName();
        EntityField idField = ((EntityReflector)reflector).getIdField();
        if (idField == null) {
            throw new QueryFlowException("the table entity not contains id column: " + entityClass.getName());
        }
        return SqlBox.deleteById(table, idField.getColumnName(), id, dataSourceTag);
    }

    public static Select select(String ... columns) {
        return new Select(columns);
    }

    public static Select select(Class<?> entityClass) {
        Assert.notNull(entityClass);
        Object reflector = ReflectionUtil.forEntityClass(entityClass);
        if (((EntityReflector)reflector).isNormalBean()) {
            throw new QueryFlowException("the class is not a table entity: " + entityClass.getName());
        }
        Iterator<FieldInvoker> iterator = ((Reflector)reflector).fieldIterator();
        String[] columns = new String[((Reflector)reflector).fieldSize()];
        int index = 0;
        while (iterator.hasNext()) {
            EntityField field = (EntityField)iterator.next();
            columns[index] = field.getColumnName();
            ++index;
        }
        return new Select(columns).from(((EntityReflector)reflector).getTableName());
    }

    public static Select select(String table, Class<?> requiredType) {
        Object reflector = ReflectionUtil.forEntityClass(requiredType);
        Iterator<FieldInvoker> iterator = ((Reflector)reflector).fieldIterator();
        String[] columns = new String[((Reflector)reflector).fieldSize()];
        int index = 0;
        while (iterator.hasNext()) {
            FieldInvoker field = iterator.next();
            columns[index] = ((EntityReflector)reflector).isNormalBean() ? field.getName() : ((EntityField)field).getColumnName();
            ++index;
        }
        return new Select(columns).from(table);
    }
}

