/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.sql;

import com.queryflow.accessor.Accessor;
import com.queryflow.accessor.AccessorFactory;
import com.queryflow.sql.Where;
import com.queryflow.utils.Utils;
import java.util.LinkedList;
import java.util.List;

public class Update
extends Where<Update> {
    private String table;
    private List<String> columns;
    private List<String> noValueColumns;

    public Update(String table) {
        this.table = table;
        this.columns = new LinkedList<String>();
        this.noValueColumns = new LinkedList<String>();
    }

    public Update set(String column, Object value) {
        this.columns.add(column);
        this.values.add(value);
        return this;
    }

    public Update set(String condition) {
        this.noValueColumns.add(condition);
        return this;
    }

    public String buildSql() {
        StringBuilder sql = new StringBuilder("UPDATE ").append(this.table).append(" SET ");
        sql.append(Utils.join(", ", this.columns, " = ?"));
        if (this.noValueColumns.isEmpty()) {
            sql.append(", ");
        }
        sql.append(Utils.join(", ", this.noValueColumns)).append((CharSequence)this.appender);
        if (this.hasWhere) {
            sql.append(")");
        }
        return sql.toString();
    }

    public int execute() {
        Accessor accessor = AccessorFactory.accessor();
        return accessor.update(this.buildSql(), Utils.toArray(this.values));
    }

    public int execute(String dataSourceTag) {
        Accessor accessor = AccessorFactory.accessor(dataSourceTag);
        return accessor.update(this.buildSql(), Utils.toArray(this.values));
    }
}

